/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.enums.QuickReturnClickType;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Util;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class QuickReturnCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.isEmpty()) {
            lng.entry(l -> l.command().quickReturn().failed(), sender, new Couple[0]);
            return false;
        }
        Player player = (Player)sender;
        MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(player.getUniqueId(), MaltsPlayer.class);
        QuickReturnClickType newQuickReturnType = Util.getEnum(args.getFirst(), QuickReturnClickType.class);
        if (newQuickReturnType == null) {
            lng.entry(l -> l.command().quickReturn().failed(), (CommandSender)player, new Couple[0]);
            return false;
        }
        maltsPlayer.setQuickReturnClickType(newQuickReturnType);
        lng.entry(l -> l.command().quickReturn().success(), (CommandSender)player, new Couple[0]);
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        return Arrays.stream(QuickReturnClickType.values()).map(it -> it.name().toLowerCase()).toList();
    }

    @Override
    public String permission() {
        return "malts.command.quickreturn";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String name() {
        return "quickreturn";
    }
}

