/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration.files;

import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.OkaeriFileName;
import dev.jsinco.malts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.malts.shaded.okaeri.configs.annotation.CustomKey;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

@OkaeriFileName(dynamicFileName=true, dynamicFileNameKey="language", dynamicFileNameFormat="translations/%s.yml")
public class Lang
extends OkaeriFile {
    private String prefix;
    private Warehouse warehouse = new Warehouse();
    private Vaults vaults = new Vaults();
    private Gui gui = new Gui();
    private Economy economy = new Economy();
    private Command command = new Command();

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, boolean prefix, Couple<String, Object> ... placeholders) {
        String entry = functionalLang.get(this);
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        return Text.mm((prefix ? this.prefix : "") + Util.replace(entry, placeholders));
    }

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, CommandSender receiver, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, true, placeholders);
        if (comp != null) {
            receiver.sendMessage(comp);
        }
        return comp;
    }

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, List<CommandSender> receivers, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, true, placeholders);
        if (comp != null) {
            receivers.forEach(receiver -> receiver.sendMessage(comp));
        }
        return comp;
    }

    @SafeVarargs
    @Nullable
    public final Component actionBarEntry(FunctionalLang functionalLang, CommandSender receiver, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, false, placeholders);
        if (comp != null) {
            receiver.sendActionBar(comp);
        }
        return comp;
    }

    @Override
    public String name() {
        return "lang.yml";
    }

    public String prefix() {
        return this.prefix;
    }

    public Warehouse warehouse() {
        return this.warehouse;
    }

    public Vaults vaults() {
        return this.vaults;
    }

    public Gui gui() {
        return this.gui;
    }

    public Economy economy() {
        return this.economy;
    }

    public Command command() {
        return this.command;
    }

    public static class Warehouse
    extends OkaeriConfig {
        private String notEnoughMaterial;
        private String notEnoughStock;
        private String inventoryFull;
        private String containerFull;
        private String removedCompartment;
        private String cannotRemoveCompartment;
        private String addedCompartment;
        private String compartmentAlreadyExists;
        private String compartmentDoesNotExist;
        private String changedMode;
        private String replenishedItem;
        private String autoStoredItem;
        private String depositedItem;
        private String cannotDepositItem;
        private String blacklistedItem;

        public String notEnoughMaterial() {
            return this.notEnoughMaterial;
        }

        public String notEnoughStock() {
            return this.notEnoughStock;
        }

        public String inventoryFull() {
            return this.inventoryFull;
        }

        public String containerFull() {
            return this.containerFull;
        }

        public String removedCompartment() {
            return this.removedCompartment;
        }

        public String cannotRemoveCompartment() {
            return this.cannotRemoveCompartment;
        }

        public String addedCompartment() {
            return this.addedCompartment;
        }

        public String compartmentAlreadyExists() {
            return this.compartmentAlreadyExists;
        }

        public String compartmentDoesNotExist() {
            return this.compartmentDoesNotExist;
        }

        public String changedMode() {
            return this.changedMode;
        }

        public String replenishedItem() {
            return this.replenishedItem;
        }

        public String autoStoredItem() {
            return this.autoStoredItem;
        }

        public String depositedItem() {
            return this.depositedItem;
        }

        public String cannotDepositItem() {
            return this.cannotDepositItem;
        }

        public String blacklistedItem() {
            return this.blacklistedItem;
        }
    }

    public static class Vaults
    extends OkaeriConfig {
        private String opening;
        private String nameChanged;
        private String noAccess;
        private String alreadyOpen;
        private String trustListMaxed;
        private String playerNeverOnServer;
        private String playerTrusted;
        private String playerUntrusted;
        private String playerNotTrusted;
        private String noVaultsFound;
        private String noVaultsAccessible;
        private String noVaultFound;
        private String vaultDeleted;
        private String vaultNameTooLong;

        public String opening() {
            return this.opening;
        }

        public String nameChanged() {
            return this.nameChanged;
        }

        public String noAccess() {
            return this.noAccess;
        }

        public String alreadyOpen() {
            return this.alreadyOpen;
        }

        public String trustListMaxed() {
            return this.trustListMaxed;
        }

        public String playerNeverOnServer() {
            return this.playerNeverOnServer;
        }

        public String playerTrusted() {
            return this.playerTrusted;
        }

        public String playerUntrusted() {
            return this.playerUntrusted;
        }

        public String playerNotTrusted() {
            return this.playerNotTrusted;
        }

        public String noVaultsFound() {
            return this.noVaultsFound;
        }

        public String noVaultsAccessible() {
            return this.noVaultsAccessible;
        }

        public String noVaultFound() {
            return this.noVaultFound;
        }

        public String vaultDeleted() {
            return this.vaultDeleted;
        }

        public String vaultNameTooLong() {
            return this.vaultNameTooLong;
        }
    }

    public static class Gui
    extends OkaeriConfig {
        private String firstPage;
        private String lastPage;
        private String viewExpired;
        private String promptInputTimeOut;

        public String firstPage() {
            return this.firstPage;
        }

        public String lastPage() {
            return this.lastPage;
        }

        public String viewExpired() {
            return this.viewExpired;
        }

        public String promptInputTimeOut() {
            return this.promptInputTimeOut;
        }
    }

    public static class Economy
    extends OkaeriConfig {
        private Vaults vaults = new Vaults();

        public Vaults vaults() {
            return this.vaults;
        }

        public static class Vaults
        extends OkaeriConfig {
            private String created;
            private String cannotAffordCreation;
            private String accessed;
            private String cannotAffordAccess;

            public String created() {
                return this.created;
            }

            public String cannotAffordCreation() {
                return this.cannotAffordCreation;
            }

            public String accessed() {
                return this.accessed;
            }

            public String cannotAffordAccess() {
                return this.cannotAffordAccess;
            }
        }
    }

    public static class Command
    extends OkaeriConfig {
        private String help;
        private Base base = new Base();
        private Max max = new Max();
        @CustomKey(value="import")
        private Import _import = new Import();
        private VaultOther vaultOther = new VaultOther();
        private Reload reload = new Reload();
        private QuickReturn quickReturn = new QuickReturn();

        public String help() {
            return this.help;
        }

        public Base base() {
            return this.base;
        }

        public Max max() {
            return this.max;
        }

        public Import _import() {
            return this._import;
        }

        public VaultOther vaultOther() {
            return this.vaultOther;
        }

        public Reload reload() {
            return this.reload;
        }

        public QuickReturn quickReturn() {
            return this.quickReturn;
        }

        public static class Base
        extends OkaeriConfig {
            private String unknownCommand;
            private String playerOnly;
            private String noPermission;

            public String unknownCommand() {
                return this.unknownCommand;
            }

            public String playerOnly() {
                return this.playerOnly;
            }

            public String noPermission() {
                return this.noPermission;
            }
        }

        public static class Max
        extends OkaeriConfig {
            private String invalidType;
            private String success;

            public String invalidType() {
                return this.invalidType;
            }

            public String success() {
                return this.success;
            }
        }

        public static class Import
        extends OkaeriConfig {
            private String cannotImport;
            private String startImport;
            private String importComplete;
            private String failedImport;

            public String cannotImport() {
                return this.cannotImport;
            }

            public String startImport() {
                return this.startImport;
            }

            public String importComplete() {
                return this.importComplete;
            }

            public String failedImport() {
                return this.failedImport;
            }
        }

        public static class VaultOther
        extends OkaeriConfig {
            private String noVaultFound;

            public String noVaultFound() {
                return this.noVaultFound;
            }
        }

        public static class Reload
        extends OkaeriConfig {
            private String success;
            private String failed;
            private String newDatabaseDriverSet;

            public String success() {
                return this.success;
            }

            public String failed() {
                return this.failed;
            }

            public String newDatabaseDriverSet() {
                return this.newDatabaseDriverSet;
            }
        }

        public static class QuickReturn
        extends OkaeriConfig {
            private String success;
            private String failed;

            public String success() {
                return this.success;
            }

            public String failed() {
                return this.failed;
            }
        }
    }

    public static interface FunctionalLang {
        public String get(Lang var1);
    }
}

