/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.enums;

import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.storage.sources.MySQLDataSource;
import dev.jsinco.malts.storage.sources.SQLiteDataSource;

public enum Driver {
    SQLITE(config -> new SQLiteDataSource(config), SQLiteDataSource.class, "SQLite"),
    MYSQL(config -> new MySQLDataSource(config), MySQLDataSource.class, "MySQL");

    private final DriverSupplier supplier;
    private final Class<? extends DataSource> identifyingClass;
    private final String asString;

    private Driver(DriverSupplier supplier, Class<? extends DataSource> identifyingClass, String asString) {
        this.supplier = supplier;
        this.identifyingClass = identifyingClass;
        this.asString = asString;
    }

    public String toString() {
        return this.asString;
    }

    public <T extends DataSource> T supply(Config.Storage config) {
        return (T)this.supplier.supply(config);
    }

    public DriverSupplier getSupplier() {
        return this.supplier;
    }

    public Class<? extends DataSource> getIdentifyingClass() {
        return this.identifyingClass;
    }

    public String getAsString() {
        return this.asString;
    }

    public static interface DriverSupplier {
        public DataSource supply(Config.Storage var1);
    }
}

