/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.importers;

import com.drtshock.playervaults.vaultmanagement.CardboardBoxSerialization;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.importers.Importer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.ClassUtil;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class PlayerVaultsImporter
implements Importer {
    @Override
    public String name() {
        return "PlayerVaults";
    }

    @Override
    public boolean canImport() {
        return ClassUtil.classExists("com.drtshock.playervaults.vaultmanagement.CardboardBoxSerialization");
    }

    @Override
    public CompletableFuture<Map<UUID, Importer.Result>> importAll() {
        File[] filesList = this.path().toFile().listFiles();
        if (filesList == null) {
            return CompletableFuture.completedFuture(Map.of());
        }
        List<CompletableFuture> futures = Arrays.stream(filesList).filter(File::isFile).map(this::importVaults).toList();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toMap(Couple::a, Couple::b)));
    }

    public CompletableFuture<Couple<UUID, Importer.Result>> importVaults(File file) {
        DataSource dataSource = DataSource.getInstance();
        String uuidAsString = file.getName().replace(".yml", "");
        UUID owner = UUID.fromString(uuidAsString);
        YamlConfiguration loadedFile = YamlConfiguration.loadConfiguration((File)file);
        List<ItemStack[]> rawInventories = loadedFile.getKeys(false).stream().map(arg_0 -> ((YamlConfiguration)loadedFile).getString(arg_0)).map(base64 -> {
            try {
                return CardboardBoxSerialization.fromStorage((String)base64, (String)uuidAsString);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).toList();
        List<ItemStack[]> inventories = rawInventories.stream().filter(inv -> inv != null && ((ItemStack[])inv).length > 0).toList();
        Importer.Result expectedResult = rawInventories.stream().anyMatch(Objects::isNull) ? Importer.Result.FAILED_TO_IMPORT_SOME_VAULTS : Importer.Result.SUCCESS;
        if (inventories.isEmpty()) {
            return CompletableFuture.completedFuture(Couple.of(owner, Importer.Result.NO_VAULTS_IN_OTHER_PLUGIN));
        }
        return dataSource.getVaults(owner).thenCompose(existing -> {
            if (!existing.isEmpty()) {
                return CompletableFuture.completedFuture(Couple.of(owner, Importer.Result.VAULTS_NOT_EMPTY));
            }
            CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
            int i = 1;
            for (ItemStack[] inv : inventories) {
                int index = i++;
                chain = chain.thenCompose(v -> dataSource.saveVault(new Vault(owner, index, inv)).thenApply(x -> {
                    Text.log("Imported vault #" + index + " for " + String.valueOf(owner));
                    return null;
                }));
            }
            return chain.thenApply(v -> Couple.of(owner, expectedResult));
        });
    }

    public Path path() {
        Path path = Malts.getInstance().getDataPath().getParent();
        return path.resolve("PlayerVaults").resolve("newvaults");
    }
}

