/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.utility;

import java.sql.SQLException;

public final class ExceptionUtil {
    public static void runWithSQLExceptionHandling(ThrowingSQLException runnable) {
        try {
            runnable.run();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            throw new RuntimeException("An unexpected error occurred", t);
        }
    }

    public static <U> U runWithSQLExceptionHandling(ThrowingSQLExceptionWithReturn<U> supplier) {
        try {
            return supplier.run();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSQLException {
        public void run() throws SQLException;
    }

    @FunctionalInterface
    public static interface ThrowingSQLExceptionWithReturn<T> {
        public T run() throws SQLException;
    }
}

