/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft;

import com.beatcraft.blocks.CornerLightTileBlock;
import com.beatcraft.blocks.EdgeLightTileBlock;
import com.beatcraft.blocks.ModBlocks;
import com.beatcraft.data.components.ModComponents;
import com.beatcraft.environment.StructurePlacer;
import com.beatcraft.items.ModItems;
import com.beatcraft.items.group.ModItemGroup;
import com.beatcraft.networking.BeatCraftNetworking;
import com.beatcraft.networking.s2c.MapSyncS2CPayload;
import com.beatcraft.networking.s2c.PlayerDisconnectS2CPayload;
import com.beatcraft.world.FirstJoinState;
import com.beatcraft.world.PlacedEnvironmentState;
import com.beatcraft.world.gen.BeatCraftWorldGeneration;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1267;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeatCraft
implements ModInitializer {
    public static final String MOD_ID = "beatcraft";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"beatcraft");
    public static UUID currentTrackedPlayer = null;
    public static String currentTrackId = null;
    public static String currentSet = null;
    public static String currentDiff = null;
    public static boolean isFlatWorld = false;
    private static final class_18.class_8645<FirstJoinState> joinStateType = new class_18.class_8645(FirstJoinState::new, FirstJoinState::fromNbt, null);
    private static final class_18.class_8645<PlacedEnvironmentState> placedEnvironmentType = new class_18.class_8645(PlacedEnvironmentState::new, PlacedEnvironmentState::fromNbt, null);

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        LOGGER.info("hi :3");
        ModComponents.init();
        ModItems.init();
        ModBlocks.init();
        ModItemGroup.init();
        BeatCraftWorldGeneration.generateWorldGen();
        BeatCraftNetworking.init();
        StructurePlacer.init();
        this.registerCommands();
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (currentTrackedPlayer == handler.field_14140.method_5667()) {
                currentTrackedPlayer = null;
                currentTrackId = null;
                currentSet = null;
                currentDiff = null;
            }
            PlayerLookup.all((MinecraftServer)server).forEach(p -> {
                if (p != handler.field_14140) {
                    ServerPlayNetworking.send((class_3222)p, (class_8710)new PlayerDisconnectS2CPayload(handler.field_14140.method_5667()));
                }
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, packetSender, server) -> {
            LOGGER.info("player connect!");
            class_3222 player = handler.field_14140;
            class_3218 world = player.method_51469();
            class_26 stateManager = world.method_17983();
            FirstJoinState state = (FirstJoinState)stateManager.method_17924(joinStateType, "beatcraft_join_state");
            StructurePlacer.setState((PlacedEnvironmentState)stateManager.method_17924(placedEnvironmentType, "beatcraft_placed_environment"));
            isFlatWorld = server.method_27728().method_45555();
            if (!isFlatWorld && !state.hasJoined()) {
                state.markJoin();
            }
            if (!state.hasJoined()) {
                state.markJoin();
                BeatCraft.placePlayArea(world);
                LOGGER.info("Auto-placed playarea");
                player.method_14251(world, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                this.initSabers((class_1657)player);
                this.initGameRules(server, world);
                player.method_43496(class_2561.method_30163((String)"\u00a7fDifficulty \u00a77set to \u00a7aPeaceful\u00a77; \u00a7fTime \u00a77set to \u00a79Midnight\u00a77; \u00a7fDoDaylightCycle\u00a77, \u00a7fDoWeatherCycle\u00a77, \u00a7fDoMobSpawning\u00a77, and \u00a7fDoTraderSpawning \u00a77 set to \u00a74false\u00a77;"));
            }
            if (currentTrackedPlayer != null) {
                packetSender.sendPacket((class_8710)new MapSyncS2CPayload(currentTrackedPlayer, currentTrackId, currentSet, currentDiff));
            }
        });
    }

    private void initSabers(class_1657 player) {
        class_1799 lSaber = new class_1799((class_1935)ModItems.SABER_ITEM);
        class_1799 rSaber = new class_1799((class_1935)ModItems.SABER_ITEM);
        lSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)0);
        lSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)0xC03030);
        rSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)1);
        rSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)2122920);
        player.method_31548().field_7544.set(0, (Object)lSaber);
        player.method_31548().method_5447(0, rSaber);
    }

    private void initGameRules(MinecraftServer server, class_3218 world) {
        ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19396)).method_20758(false, server);
        ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19406)).method_20758(false, server);
        ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_21832)).method_20758(false, server);
        ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19390)).method_20758(false, server);
        world.method_29199(18000L);
        server.method_3776(class_1267.field_5801, true);
    }

    private static int giveSabers(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            class_1799 lSaber = new class_1799((class_1935)ModItems.SABER_ITEM);
            class_1799 rSaber = new class_1799((class_1935)ModItems.SABER_ITEM);
            lSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)0);
            lSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)0xC03030);
            rSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)1);
            rSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)2122920);
            player.method_7270(lSaber);
            player.method_7270(rSaber);
        }
        return 1;
    }

    private static void fillBlocks(class_3218 world, class_2338 minPos, class_2338 maxPos, class_2680 blockState) {
        for (int x = minPos.method_10263(); x <= maxPos.method_10263(); ++x) {
            for (int y = minPos.method_10264(); y <= maxPos.method_10264(); ++y) {
                for (int z = minPos.method_10260(); z <= maxPos.method_10260(); ++z) {
                    world.method_8501(new class_2338(x, y, z), blockState);
                }
            }
        }
    }

    private static int generatePlayArea(CommandContext<class_2168> context) {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        BeatCraft.placePlayArea(world);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Generated play area at world origin"), true);
        return 1;
    }

    private static void placePlayArea(class_3218 world) {
        BeatCraft.fillBlocks(world, new class_2338(-2, -64, -2), new class_2338(1, -2, 1), ModBlocks.BLACK_MIRROR_BLOCK.method_9564());
        BeatCraft.fillBlocks(world, new class_2338(-2, -1, -2), new class_2338(1, -1, 1), ModBlocks.REFLECTIVE_MIRROR_BLOCK.method_9564());
        world.method_8501(new class_2338(1, 0, -2), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11034));
        world.method_8501(new class_2338(1, 0, -1), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11034));
        world.method_8501(new class_2338(1, 0, 0), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11034));
        world.method_8501(new class_2338(1, 0, 1), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11035));
        world.method_8501(new class_2338(0, 0, 1), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11035));
        world.method_8501(new class_2338(-1, 0, 1), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11035));
        world.method_8501(new class_2338(-2, 0, 1), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11039));
        world.method_8501(new class_2338(-2, 0, 0), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11039));
        world.method_8501(new class_2338(-2, 0, -1), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11039));
        world.method_8501(new class_2338(-2, 0, -2), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11043));
        world.method_8501(new class_2338(-1, 0, -2), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11043));
        world.method_8501(new class_2338(0, 0, -2), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11043));
        BeatCraft.fillBlocks(world, new class_2338(-2, -1, 8), new class_2338(1, -1, 300), ModBlocks.BLACK_MIRROR_BLOCK.method_9564());
        BeatCraft.fillBlocks(world, new class_2338(-2, 0, 8), new class_2338(-2, 0, 290), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11039));
        BeatCraft.fillBlocks(world, new class_2338(1, 0, 8), new class_2338(1, 0, 290), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11033)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11034));
        world.method_8501(new class_2338(1, -1, 7), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11035)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11034));
        world.method_8501(new class_2338(0, -1, 7), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11035)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11033));
        world.method_8501(new class_2338(-1, -1, 7), (class_2680)((class_2680)ModBlocks.EDGE_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)EdgeLightTileBlock.FACE, (Comparable)class_2350.field_11035)).method_11657((class_2769)EdgeLightTileBlock.ROTATION, (Comparable)class_2350.field_11033));
        world.method_8501(new class_2338(-2, -1, 7), (class_2680)((class_2680)ModBlocks.CORNER_LIGHT_TILE_BLOCK.method_9564().method_11657((class_2769)CornerLightTileBlock.FACE, (Comparable)class_2350.field_11035)).method_11657((class_2769)CornerLightTileBlock.ROTATION, (Comparable)class_2350.field_11033));
    }

    private static int outputCurrentEnvironment(CommandContext<class_2168> context) {
        if (StructurePlacer.currentStructure.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"No environment is currently placed"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)String.format("Current environment: %s", StructurePlacer.currentStructure)), false);
        }
        return 1;
    }

    private static int removeEnvironment(CommandContext<class_2168> context) {
        if (StructurePlacer.removeStructure(((class_2168)context.getSource()).method_9225())) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Removed environment structure"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"No environment to remove"), false);
        }
        return 1;
    }

    private static int placeEnvironment(CommandContext<class_2168> context) {
        String environment = StringArgumentType.getString(context, (String)"environment");
        if (StructurePlacer.placeStructureForced(environment, ((class_2168)context.getSource()).method_9225())) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)String.format("Placed environment '%s'", environment)), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)String.format("'%s' is not a valid environment", environment)), true);
        }
        return 1;
    }

    private CompletableFuture<Suggestions> environmentSuggester(CommandContext<class_2168> context, SuggestionsBuilder suggestionsBuilder) {
        String partial = suggestionsBuilder.getRemaining();
        StructurePlacer.matchEnvironments(partial).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    private int centerPlayer(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            player.method_14251(((class_2168)context.getSource()).method_9225(), 0.0, 0.0, 0.0, 0.0f, 0.0f);
            return 1;
        }
        return -1;
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sabers").requires(source -> source.method_9259(2))).executes(BeatCraft::giveSabers));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"playarea").requires(source -> source.method_9259(2))).executes(BeatCraft::generatePlayArea));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"environment").requires(source -> source.method_9259(2))).executes(BeatCraft::outputCurrentEnvironment)).then(class_2170.method_9247((String)"remove").executes(BeatCraft::removeEnvironment))).then(class_2170.method_9247((String)"place").then(class_2170.method_9244((String)"environment", (ArgumentType)StringArgumentType.string()).suggests(this::environmentSuggester).executes(BeatCraft::placeEnvironment))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"center").requires(source -> source.method_9259(2))).executes(this::centerPlayer));
        });
    }
}

