/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft;

import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.beatmap.BeatmapLoader;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.networking.c2s.SongPauseC2SPayload;
import com.beatcraft.networking.c2s.SpeedSyncC2SPayload;
import com.beatcraft.render.HUDRenderer;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class BeatmapPlayer {
    protected static final class_310 mc = class_310.method_1551();
    public static Difficulty currentBeatmap = null;
    public static Info currentInfo = null;
    private static ArrayList<Runnable> setupCalls = new ArrayList();
    private static long lastNanoTime = 0L;
    private static long elapsedNanoTime = 0L;
    private static float playbackSpeed = 1.0f;
    private static boolean isPlaying = false;

    public static float getCurrentBeat() {
        if (currentInfo == null) {
            return 0.0f;
        }
        return currentInfo.getBeat(BeatmapPlayer.getCurrentSeconds(), 1.0f);
    }

    public static float getCurrentSeconds() {
        return BeatmapPlayer.nanoToSeconds(elapsedNanoTime);
    }

    private static void setCurrentSeconds(float seconds) {
        elapsedNanoTime = BeatmapPlayer.secondsToNano(seconds);
    }

    public static void setCurrentBeat(float beat) {
        if (currentInfo == null) {
            return;
        }
        currentBeatmap.seek(beat);
        float seconds = currentInfo.getTime(beat, 0.0f);
        elapsedNanoTime = BeatmapPlayer.secondsToNano(seconds);
    }

    private static float nanoToSeconds(long nanoseconds) {
        return (float)nanoseconds / 1.0E9f;
    }

    private static long secondsToNano(float seconds) {
        return (long)(seconds * 1.0E9f);
    }

    private static void updateLastNanoTime() {
        lastNanoTime = System.nanoTime();
    }

    private static long getNanoDeltaTime() {
        long nanoDeltaTime = System.nanoTime() - lastNanoTime;
        BeatmapPlayer.updateLastNanoTime();
        if (nanoDeltaTime > 1000000000L) {
            return 0L;
        }
        return nanoDeltaTime;
    }

    public static float getPlaybackSpeed() {
        return playbackSpeed;
    }

    public static void setPlaybackSpeed(float speed) {
        try {
            BeatmapPlayer.setPlaybackSpeed(speed, false);
        }
        catch (Exception e) {
            setupCalls.add(() -> BeatmapPlayer.setPlaybackSpeed(speed));
        }
    }

    public static void setPlaybackSpeed(float speed, boolean skipPacketSend) {
        BeatmapAudioPlayer.beatmapAudio.setPlaybackSpeed(speed);
        BeatmapAudioPlayer.syncTimeWithBeatmap();
        playbackSpeed = speed;
        if (!skipPacketSend) {
            ClientPlayNetworking.send((class_8710)new SpeedSyncC2SPayload(speed));
        }
    }

    public static boolean isPlaying() {
        return isPlaying;
    }

    public static void play() {
        BeatmapAudioPlayer.syncTimeWithBeatmap();
        isPlaying = true;
    }

    public static void play(float beat) {
        BeatmapPlayer.setCurrentBeat(beat);
        BeatmapAudioPlayer.syncTimeWithBeatmap();
        isPlaying = true;
    }

    public static void pause() {
        BeatmapPlayer.pause(false);
    }

    public static void pause(boolean skipPacketSend) {
        isPlaying = false;
        if (!skipPacketSend) {
            ClientPlayNetworking.send((class_8710)new SongPauseC2SPayload());
        }
    }

    public static void restart() {
        BeatmapPlayer.play(0.0f);
    }

    public static void onRender(class_4587 matrices, class_4184 camera, float tickDelta) {
        boolean shouldMapPlay;
        long deltaNanoSeconds = BeatmapPlayer.getNanoDeltaTime();
        if (!setupCalls.isEmpty()) {
            for (Runnable call : setupCalls) {
                call.run();
            }
            setupCalls.clear();
        }
        boolean bl = shouldMapPlay = isPlaying && !mc.method_1493() && BeatmapAudioPlayer.isReady();
        if (shouldMapPlay) {
            elapsedNanoTime += (long)((float)deltaNanoSeconds * playbackSpeed);
            if (currentBeatmap != null) {
                currentBeatmap.update(BeatmapPlayer.getCurrentBeat(), (double)deltaNanoSeconds / 1.0E9);
            }
        }
        if (HUDRenderer.scene == HUDRenderer.MenuScene.InGame || HUDRenderer.scene == HUDRenderer.MenuScene.Paused) {
            BeatmapAudioPlayer.onFrame();
        }
        GameLogicHandler.preUpdate((double)deltaNanoSeconds / 1.0E9, tickDelta);
        if (currentBeatmap != null) {
            currentBeatmap.render(matrices, camera);
        }
        GameLogicHandler.update((double)deltaNanoSeconds / 1.0E9, tickDelta);
    }

    public static void setupDifficultyFromFile(String path) throws IOException {
        Path p = Paths.get(path, new String[0]);
        String infoPath = p.getParent().toString() + "/Info.dat";
        Info info = null;
        try {
            info = BeatmapLoader.getInfoFromFile(infoPath);
        }
        catch (NoSuchFileException e) {
            infoPath = p.getParent().toString() + "/info.dat";
            info = BeatmapLoader.getInfoFromFile(infoPath);
        }
        currentBeatmap = BeatmapLoader.getDifficultyFromFile(path, info);
        currentInfo = info;
    }

    public static void reset() {
        currentInfo = null;
        currentBeatmap = null;
        isPlaying = false;
        elapsedNanoTime = 0L;
        lastNanoTime = 0L;
    }
}

