/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.event;

import com.beatcraft.animation.event.AnimatedPathEvent;
import com.beatcraft.animation.event.InterpolatedPath;
import com.beatcraft.animation.event.Path;
import com.beatcraft.animation.event.StaticPath;
import com.beatcraft.animation.pointdefinition.PointDefinition;
import com.beatcraft.event.EventHandler;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AnimatedPathEventHandler<T>
extends EventHandler<Path<T>, AnimatedPathEvent<T>> {
    private PointDefinition<T> previousProperty = null;

    public AnimatedPathEventHandler(ArrayList<AnimatedPathEvent<T>> events, Path<T> initialState) {
        super(events, initialState);
    }

    @Override
    public void reset() {
        super.reset();
        this.previousProperty = null;
    }

    @Override
    public void onEventInterrupted(AnimatedPathEvent<T> event, float normalTime) {
        this.previousProperty = event.getProperty();
    }

    @Override
    public void onInsideEvent(AnimatedPathEvent<T> event, float normalTime) {
        if (this.previousProperty != null) {
            normalTime = event.applyEasing(normalTime);
            this.state = new InterpolatedPath<T>(this.previousProperty, event.getProperty(), normalTime);
        } else {
            this.state = new StaticPath<T>(event.getProperty());
        }
    }

    @Override
    public void onEventPassed(AnimatedPathEvent<T> event) {
        this.state = new StaticPath<T>(event.getProperty());
        this.previousProperty = event.getProperty();
    }
}

