/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.event;

import com.beatcraft.animation.event.Path;
import com.beatcraft.animation.pointdefinition.PointDefinition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class InterpolatedPath<T>
extends Path<T> {
    private final PointDefinition<T> pointsA;
    private final PointDefinition<T> pointsB;
    private final float normalTime;

    public InterpolatedPath(PointDefinition<T> pointsA, PointDefinition<T> pointsB, float normalTime) {
        this.pointsA = pointsA;
        this.pointsB = pointsB;
        this.normalTime = normalTime;
    }

    @Override
    public T interpolate(float time, Path.Interpolation<T> interpolation) {
        T resultA = this.pointsA.interpolate(time);
        T resultB = this.pointsB.interpolate(time);
        return interpolation.apply(resultA, resultB, this.normalTime);
    }
}

