/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.pointdefinition;

import com.beatcraft.animation.pointdefinition.Point;
import com.beatcraft.animation.pointdefinition.PointDefinition;
import com.google.gson.JsonArray;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Math;

@Environment(value=EnvType.CLIENT)
public class FloatPointDefinition
extends PointDefinition<Float> {
    public FloatPointDefinition(JsonArray json) throws RuntimeException {
        super(json);
    }

    @Override
    protected Float interpolatePoints(int a, int b, float time) {
        float left = ((Float)((Point)this.points.get(a)).getValue()).floatValue();
        float right = ((Float)((Point)this.points.get(b)).getValue()).floatValue();
        return Float.valueOf(Math.lerp((float)left, (float)right, (float)time));
    }

    @Override
    protected int getValueLength() {
        return 1;
    }

    @Override
    protected void loadValue(JsonArray json, Point<Float> point, boolean isSimple) {
        float value = json.get(0).getAsFloat();
        point.setValue(Float.valueOf(value));
    }
}

