/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.pointdefinition;

import com.beatcraft.animation.pointdefinition.Point;
import com.beatcraft.animation.pointdefinition.PointDefinition;
import com.beatcraft.utils.JsonUtil;
import com.beatcraft.utils.MathUtil;
import com.google.gson.JsonArray;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Vector3PointDefinition
extends PointDefinition<Vector3f> {
    public Vector3PointDefinition(JsonArray json) throws RuntimeException {
        super(json);
    }

    @Override
    protected Vector3f interpolatePoints(int a, int b, float time) {
        Point right = (Point)this.points.get(b);
        if (right.isSpline()) {
            return this.splineInterpolation(a, b, time);
        }
        Point left = (Point)this.points.get(a);
        return MathUtil.lerpVector3((Vector3f)left.getValue(), (Vector3f)right.getValue(), time);
    }

    @Override
    protected int getValueLength() {
        return 3;
    }

    @Override
    protected void loadValue(JsonArray json, Point<Vector3f> point, boolean isSimple) {
        Vector3f vector = JsonUtil.getVector3(json);
        point.setValue(vector);
    }

    protected Vector3f splineInterpolation(int a, int b, float time) {
        Vector3f pa = (Vector3f)((Point)this.points.get(a)).getValue();
        Vector3f pb = (Vector3f)((Point)this.points.get(b)).getValue();
        Vector3f p0 = a - 1 < 0 ? pa : (Vector3f)((Point)this.points.get(a - 1)).getValue();
        Vector3f p3 = b + 1 > this.points.size() - 1 ? pb : (Vector3f)((Point)this.points.get(b + 1)).getValue();
        float tt = time * time;
        float ttt = tt * time;
        float q0 = -ttt + 2.0f * tt - time;
        float q1 = 3.0f * ttt - 5.0f * tt + 2.0f;
        float q2 = -3.0f * ttt + 4.0f * tt + time;
        float q3 = ttt - tt;
        return new Vector3f(0.5f * (p0.x * q0 + pa.x * q1 + pb.x * q2 + p3.x * q3), 0.5f * (p0.y * q0 + pa.y * q1 + pb.y * q2 + p3.y * q3), 0.5f * (p0.z * q0 + pa.z * q1 + pb.z * q2 + p3.z * q3));
    }
}

