/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.animation.track;

import com.beatcraft.animation.AnimationState;
import com.beatcraft.animation.track.Track;
import com.beatcraft.animation.track.TrackLibrary;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ObjectTrackContainer {
    private final ArrayList<Track> tracks = new ArrayList();

    public void loadTracks(JsonElement trackElement, TrackLibrary trackLibrary) {
        this.tracks.addAll(Track.getTracksAsList(trackElement, trackLibrary));
    }

    public AnimationState getAnimatedPropertyState() {
        Optional<AnimationState> state = this.tracks.stream().map(track -> track.getAnimatedProperties().getCurrentState()).reduce(AnimationState::combine);
        return state.orElseGet(AnimationState::new);
    }

    public AnimationState getAnimatedPathState(float time) {
        Optional<AnimationState> state = this.tracks.stream().map(track -> track.getAnimatedPath().getCurrentState().interpolate(time)).reduce(AnimationState::combine);
        return state.orElseGet(AnimationState::new);
    }

    public Matrix4f tryGetParentMatrix() {
        Optional<Track> parentTrack = this.tracks.stream().filter(Track::isParented).findFirst();
        return parentTrack.map(Track::tryGetParentMatrix).orElse(null);
    }
}

