/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.audio;

import com.beatcraft.BeatCraft;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AudioInfo {
    private final float songDuration;
    private final int frequency;
    private final ArrayList<BpmRegion> regions = new ArrayList();

    private AudioInfo(int sampleCount, int frequency) {
        this.songDuration = (float)sampleCount / (float)frequency;
        this.frequency = frequency;
    }

    public float getSongDuration() {
        return this.songDuration;
    }

    public static AudioInfo loadV4(JsonObject json) {
        int sampleCount = json.get("songSampleCount").getAsInt();
        int frequency = json.get("songFrequency").getAsInt();
        AudioInfo info = new AudioInfo(sampleCount, frequency);
        JsonArray regions = json.getAsJsonArray("bpmData");
        regions.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BpmRegion bpmRegion = BpmRegion.loadV4(obj, info);
            info.regions.add(bpmRegion);
        });
        return info;
    }

    public float getBeat(float time, float speedModifier) {
        float beat = 0.0f;
        for (BpmRegion region : this.regions) {
            float b = region.getBeat(time, speedModifier);
            if (b == 0.0f) {
                return beat;
            }
            beat = b;
        }
        return beat;
    }

    public float getTime(float beat, float speedModifier) {
        float t = 0.0f;
        for (BpmRegion region : this.regions) {
            t += region.getTime(beat, speedModifier);
        }
        return t;
    }

    @Environment(value=EnvType.CLIENT)
    public static class BpmRegion {
        private final int startIndex;
        private final int endIndex;
        private final float startBeat;
        private final float endBeat;
        private final AudioInfo info;

        private BpmRegion(AudioInfo parent, int startIndex, int endIndex, float startBeat, float endBeat) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.startBeat = startBeat;
            this.endBeat = endBeat;
            this.info = parent;
        }

        public float getBeat(float time, float speedModifier) {
            float startTime = (float)this.startIndex / (float)this.info.frequency * speedModifier;
            if (time < startTime) {
                return 0.0f;
            }
            float duration = (float)this.endIndex / (float)this.info.frequency * speedModifier - startTime;
            float progress = Math.clamp((time - startTime) / duration, 0.0f, 1.0f);
            return this.startBeat + progress * (this.endBeat - this.startBeat);
        }

        public float getTime(float beat, float speedModifier) {
            if (beat < this.startBeat) {
                return 0.0f;
            }
            float progress = Math.clamp((beat - this.startBeat) / (this.endBeat - this.startBeat), 0.0f, 1.0f);
            float samples = (float)(this.endIndex - this.startIndex) * progress;
            float t = samples / (float)this.info.frequency;
            return t * speedModifier;
        }

        public static BpmRegion loadV2(JsonObject json, AudioInfo parent) {
            return new BpmRegion(parent, json.get("_startSampleIndex").getAsInt(), json.get("_endSampleIndex").getAsInt(), json.get("_startBeat").getAsFloat(), json.get("_endBeat").getAsFloat());
        }

        public static BpmRegion loadV4(JsonObject json, AudioInfo parent) {
            BpmRegion region = new BpmRegion(parent, json.get("si").getAsInt(), json.get("ei").getAsInt(), json.get("sb").getAsFloat(), json.get("eb").getAsFloat());
            BeatCraft.LOGGER.info("BPM Region made: {}, {}, {}, {}", new Object[]{region.startIndex, region.endIndex, Float.valueOf(region.startBeat), Float.valueOf(region.endBeat)});
            return region;
        }
    }
}

