/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.audio;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.render.HUDRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.sound.sampled.AudioFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4228;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;

@Environment(value=EnvType.CLIENT)
public class BeatmapAudio {
    private int buffer;
    private final int source = AL10.alGenSources();
    private boolean isPlaying = false;
    private boolean isLoaded = false;
    private float songDuration = 0.0f;

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void pause() {
        if (this.isPlaying && this.isLoaded) {
            AL10.alSourcePause((int)this.source);
            this.isPlaying = false;
        }
    }

    public void stop() {
        if (this.isPlaying && this.isLoaded) {
            AL10.alSourceStop((int)this.source);
            this.isPlaying = false;
        }
    }

    public void play() {
        this.setVolume(BeatCraftClient.playerConfig.getVolume());
        if (!this.isPlaying && this.isLoaded) {
            AL10.alSourcePlay((int)this.source);
            this.isPlaying = true;
        }
    }

    public void play(float time) {
        this.seek(time);
        this.play();
    }

    public void seek(float time) {
        if (this.isLoaded) {
            AL11.alSourcef((int)this.source, (int)4132, (float)(time + (float)BeatCraftClient.playerConfig.getLatency() / 1.0E9f));
        }
    }

    public void setVolume(float volume) {
        AL10.alSourcef((int)this.source, (int)4106, (float)volume);
    }

    public void setPlaybackSpeed(float speed) {
        AL10.alSourcef((int)this.source, (int)4099, (float)speed);
    }

    private int getFormatID(AudioFormat format) {
        AudioFormat.Encoding encoding = format.getEncoding();
        int channels = format.getChannels();
        int sampleSize = format.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (channels == 1) {
                if (sampleSize == 8) {
                    return 4352;
                }
                if (sampleSize == 16) {
                    return 4353;
                }
            } else if (channels == 2) {
                if (sampleSize == 8) {
                    return 4354;
                }
                if (sampleSize == 16) {
                    return 4355;
                }
            }
        }
        throw new IllegalArgumentException("Invalid audio format: " + String.valueOf(format));
    }

    public static float getDuration(int bufferId) {
        int size = AL10.alGetBufferi((int)bufferId, (int)8196);
        int frequency = AL10.alGetBufferi((int)bufferId, (int)8193);
        int channels = AL10.alGetBufferi((int)bufferId, (int)8195);
        int bits = AL10.alGetBufferi((int)bufferId, (int)8194);
        int bytesPerSample = bits / 8;
        return (float)size / (float)(frequency * channels * bytesPerSample);
    }

    private static void logErrorAndReset(String path) {
        HUDRenderer.errorMessagePanel.setContent("\nSong Failed to load!\n\nPlease view logs\nfor more info");
        BeatCraft.LOGGER.error("\n///\n/// Song Failed to load: {}\n/// This is most likely due to the song's encoding.\n/// Check here for how to fix: https://github.com/Swifter1243/BeatCraft/wiki/Troubleshooting#encoding-issues\n///\n", (Object)path);
        BeatmapPlayer.currentInfo = null;
        BeatmapPlayer.currentBeatmap = null;
        HUDRenderer.scene = HUDRenderer.MenuScene.SongSelect;
    }

    public void loadAudioFromFile(String path) throws IOException {
        ByteBuffer audioData;
        class_4228 oggAudioStream;
        this.closeBuffer();
        InputStream inputStream = Files.newInputStream(Path.of(path, new String[0]), new OpenOption[0]);
        try {
            oggAudioStream = new class_4228(inputStream);
        }
        catch (IOException e) {
            BeatmapAudio.logErrorAndReset(path);
            throw e;
        }
        AudioFormat format = oggAudioStream.method_19719();
        this.buffer = AL10.alGenBuffers();
        int formatID = this.getFormatID(format);
        int sampleRate = (int)format.getSampleRate();
        try {
            audioData = oggAudioStream.method_59757();
        }
        catch (IOException e) {
            BeatmapAudio.logErrorAndReset(path);
            throw e;
        }
        AL10.alBufferData((int)this.buffer, (int)formatID, (ByteBuffer)audioData, (int)sampleRate);
        AL10.alSourcei((int)this.source, (int)4105, (int)this.buffer);
        this.songDuration = BeatmapAudio.getDuration(this.buffer);
        if (this.songDuration == 0.0f) {
            BeatmapAudio.logErrorAndReset(path);
            throw new IOException("Song has 0 duration");
        }
        this.isLoaded = true;
        inputStream.close();
        oggAudioStream.close();
    }

    public float getSongDuration() {
        return this.songDuration;
    }

    public void closeBuffer() {
        if (this.isLoaded) {
            this.stop();
            AL10.alDeleteBuffers((int)this.buffer);
            this.isLoaded = false;
        }
    }
}

