/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.animation.event.AnimatedPathEventContainer;
import com.beatcraft.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.animation.track.TrackLibrary;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.event.AnimateTrack;
import com.beatcraft.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.beatmap.data.event.AssignTrackParent;
import com.beatcraft.beatmap.data.event.AssignTrackParentHandler;
import com.beatcraft.beatmap.data.event.RotationEvent;
import com.beatcraft.beatmap.data.event.RotationEventHandler;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.event.EventHandler;
import com.beatcraft.lightshow.environment.Environment;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.lightshow_event_visualizer.EventVisualizer;
import com.beatcraft.render.object.PhysicalArc;
import com.beatcraft.render.object.PhysicalBombNote;
import com.beatcraft.render.object.PhysicalChainNoteHead;
import com.beatcraft.render.object.PhysicalChainNoteLink;
import com.beatcraft.render.object.PhysicalColorNote;
import com.beatcraft.render.object.PhysicalGameplayObject;
import com.beatcraft.render.object.PhysicalObstacle;
import com.beatcraft.replay.PlayRecorder;
import com.beatcraft.replay.Replayer;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Math;
import org.joml.Quaternionf;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public abstract class Difficulty {
    private final Info info;
    private final Info.SetDifficulty setDifficulty;
    private final TrackLibrary trackLibrary = new TrackLibrary();
    public final ArrayList<PhysicalColorNote> colorNotes = new ArrayList();
    public final ArrayList<PhysicalBombNote> bombNotes = new ArrayList();
    public final ArrayList<PhysicalChainNoteHead> chainHeadNotes = new ArrayList();
    public final ArrayList<PhysicalChainNoteLink> chainLinkNotes = new ArrayList();
    public final ArrayList<PhysicalObstacle> obstacles = new ArrayList();
    public final ArrayList<PhysicalArc> arcs = new ArrayList();
    public final ArrayList<RotationEvent> rotationEvents = new ArrayList();
    public final ArrayList<AnimateTrack> animateTracks = new ArrayList();
    public final ArrayList<AssignPathAnimation> assignPathAnimations = new ArrayList();
    public final ArrayList<AssignTrackParent> assignTrackParents = new ArrayList();
    public final AssignTrackParentHandler parentHandler = new AssignTrackParentHandler(this.assignTrackParents, this.trackLibrary);
    public final HashMap<String, JsonArray> pointDefinitions = new HashMap();
    public Environment lightShowEnvironment;

    public Difficulty(Info info, Info.SetDifficulty setDifficulty) {
        this.info = info;
        this.setDifficulty = setDifficulty;
    }

    public static int compareObjects(BeatmapObject o1, BeatmapObject o2) {
        float b;
        float a = o1.getBeat();
        if (a == (b = o2.getBeat())) {
            return 0;
        }
        return a > b ? 1 : -1;
    }

    private void sortObjectsByTime() {
        this.colorNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.bombNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.chainHeadNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.chainLinkNotes.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.obstacles.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.arcs.sort((o1, o2) -> Difficulty.compareObjects(o1.getData(), o2.getData()));
        this.rotationEvents.sort(Difficulty::compareObjects);
        this.animateTracks.sort(Difficulty::compareObjects);
        this.assignPathAnimations.sort(Difficulty::compareObjects);
    }

    private void applyRotationEvents() {
        RotationEventHandler eventHandler = new RotationEventHandler(this.rotationEvents);
        this.applyRotationOnArray(eventHandler, this.colorNotes);
        this.applyRotationOnArray(eventHandler, this.bombNotes);
        this.applyRotationOnArray(eventHandler, this.chainHeadNotes);
        this.applyRotationOnArray(eventHandler, this.chainLinkNotes);
        this.applyRotationOnArray(eventHandler, this.obstacles);
        this.applyRotationOnArray(eventHandler, this.arcs);
    }

    private <T extends PhysicalGameplayObject<K>, K extends GameplayObject> void applyRotationOnArray(EventHandler<Float, RotationEvent> eventHandler, ArrayList<T> array) {
        eventHandler.reset();
        array.forEach(o -> {
            float beat = ((BeatmapObject)o.getData()).getBeat();
            float rotation = ((Float)eventHandler.update(beat)).floatValue();
            if (rotation != 0.0f) {
                o.setLaneRotation(new Quaternionf().rotateY(Math.toRadians((float)rotation)));
            }
        });
    }

    private void checkNotesWindowSnap() {
        Map<NoteType, List<PhysicalColorNote>> noteTypes = this.colorNotes.stream().collect(Collectors.groupingBy(o -> o.getData().getNoteType()));
        noteTypes.forEach((type, typedNotes) -> {
            Map<Float, List<PhysicalColorNote>> timeGroups = typedNotes.stream().collect(Collectors.groupingBy(o -> Float.valueOf(o.getData().getBeat())));
            timeGroups.forEach((time, notes) -> {
                if (notes.size() != 2) {
                    return;
                }
                PhysicalColorNote a = (PhysicalColorNote)notes.get(0);
                PhysicalColorNote b = (PhysicalColorNote)notes.get(1);
                a.checkWindowSnap(b);
                b.checkWindowSnap(a);
            });
        });
    }

    private void finalizeBaseRotations() {
        this.colorNotes.forEach(PhysicalColorNote::finalizeBaseRotation);
        this.chainHeadNotes.forEach(PhysicalChainNoteHead::finalizeBaseRotation);
        this.chainLinkNotes.forEach(PhysicalChainNoteLink::finalizeBaseRotation);
    }

    private void setupAnimatedProperties() {
        this.animateTracks.forEach(event -> {
            AnimatedPropertyEventContainer animatedPropertyEvents = event.toAnimatedPropertyEvents();
            event.getTracks().forEach(track -> track.loadAnimatedPropertyEvents(animatedPropertyEvents));
        });
        this.assignPathAnimations.forEach(event -> {
            AnimatedPathEventContainer animatedPathEvents = event.toAnimatedPathEvents();
            event.getTracks().forEach(track -> track.loadAnimatedPathEvents(animatedPathEvents));
        });
    }

    protected void doPostLoad() {
        this.sortObjectsByTime();
        this.checkNotesWindowSnap();
        this.finalizeBaseRotations();
        this.applyRotationEvents();
        this.setupAnimatedProperties();
    }

    public Info getInfo() {
        return this.info;
    }

    public Info.SetDifficulty getSetDifficulty() {
        return this.setDifficulty;
    }

    public void render(class_4587 matrices, class_4184 camera) {
        if (HUDRenderer.scene == HUDRenderer.MenuScene.Paused) {
            return;
        }
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.render(matrices, camera);
        }
        if (BeatCraftClient.playerConfig.isModifierActive("Zen Mode")) {
            return;
        }
        this.colorNotes.forEach(o -> o.render(matrices, camera));
        if (!BeatCraftClient.playerConfig.isModifierActive("No Bombs")) {
            this.bombNotes.forEach(o -> o.render(matrices, camera));
        }
        this.chainHeadNotes.forEach(o -> o.render(matrices, camera));
        this.chainLinkNotes.forEach(o -> o.render(matrices, camera));
        if (!BeatCraftClient.playerConfig.isModifierActive("No Walls")) {
            this.obstacles.forEach(o -> o.render(matrices, camera));
        }
        this.arcs.forEach(o -> o.render(matrices, camera));
    }

    public void seek(float beat) {
        this.trackLibrary.seek(beat);
        this.parentHandler.seek(beat);
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.seek(beat);
        }
        this.colorNotes.forEach(o -> o.seek(beat));
        this.bombNotes.forEach(o -> o.seek(beat));
        this.chainHeadNotes.forEach(o -> o.seek(beat));
        this.chainLinkNotes.forEach(o -> o.seek(beat));
        this.obstacles.forEach(o -> o.seek(beat));
        this.arcs.forEach(o -> o.seek(beat));
        PlayRecorder.seek(beat);
        Replayer.seek(beat);
    }

    public void update(float beat, double deltaTime) {
        this.trackLibrary.update(beat);
        this.parentHandler.update(beat);
        if (this.lightShowEnvironment != null) {
            this.lightShowEnvironment.update(beat, deltaTime);
            EventVisualizer.update(beat);
        }
        if (BeatCraftClient.playerConfig.isModifierActive("Zen Mode")) {
            return;
        }
        this.colorNotes.forEach(o -> o.update(beat));
        if (!BeatCraftClient.playerConfig.isModifierActive("No Bombs")) {
            this.bombNotes.forEach(o -> o.update(beat));
        }
        this.chainHeadNotes.forEach(o -> o.update(beat));
        this.chainLinkNotes.forEach(o -> o.update(beat));
        if (!BeatCraftClient.playerConfig.isModifierActive("No Walls")) {
            this.obstacles.forEach(o -> o.update(beat));
        }
        this.arcs.forEach(o -> o.update(beat));
        PlayRecorder.update(beat);
        Replayer.update(beat);
    }

    public TrackLibrary getTrackLibrary() {
        return this.trackLibrary;
    }
}

