/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.EventGroup;
import com.beatcraft.beatmap.data.event.AnimateTrack;
import com.beatcraft.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.beatmap.data.event.AssignTrackParent;
import com.beatcraft.beatmap.data.event.RotationEvent;
import com.beatcraft.beatmap.data.object.Arc;
import com.beatcraft.beatmap.data.object.BombNote;
import com.beatcraft.beatmap.data.object.ChainNoteHead;
import com.beatcraft.beatmap.data.object.ChainNoteLink;
import com.beatcraft.beatmap.data.object.ColorNote;
import com.beatcraft.beatmap.data.object.Obstacle;
import com.beatcraft.lightshow.environment.EnvironmentUtils;
import com.beatcraft.render.object.PhysicalArc;
import com.beatcraft.render.object.PhysicalBombNote;
import com.beatcraft.render.object.PhysicalChainNoteHead;
import com.beatcraft.render.object.PhysicalChainNoteLink;
import com.beatcraft.render.object.PhysicalColorNote;
import com.beatcraft.render.object.PhysicalObstacle;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;

@Environment(value=EnvType.CLIENT)
public class DifficultyV3
extends Difficulty {
    public DifficultyV3(Info info, Info.SetDifficulty setDifficulty) {
        super(info, setDifficulty);
    }

    DifficultyV3 load(JsonObject json) {
        this.loadChains(json);
        this.loadNotes(json);
        this.loadBombs(json);
        this.loadArcs(json);
        this.loadObstacles(json);
        this.loadBasicEvents(json);
        this.loadRotationEvents(json);
        this.loadPointDefinitions(json);
        this.loadCustomEvents(json);
        this.loadLightshow(json);
        this.doPostLoad();
        return this;
    }

    void loadNotes(JsonObject json) {
        JsonObject customData;
        JsonArray rawColorNotes = json.getAsJsonArray("colorNotes");
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("fakeColorNotes")) {
            rawColorNotes.addAll(customData.getAsJsonArray("fakeColorNotes"));
        }
        rawColorNotes.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            ColorNote note = new ColorNote().loadV3(obj, this);
            AtomicBoolean canAdd = new AtomicBoolean(true);
            this.chainHeadNotes.forEach(c -> {
                if (note.getBeat() == ((ChainNoteHead)c.getData()).getBeat() && note.getX() == ((ChainNoteHead)c.getData()).getX() && note.getY() == ((ChainNoteHead)c.getData()).getY()) {
                    canAdd.set(false);
                }
            });
            if (canAdd.get()) {
                this.colorNotes.add(new PhysicalColorNote(note));
            }
        });
    }

    void loadBombs(JsonObject json) {
        JsonObject customData;
        JsonArray rawBombNotes = json.getAsJsonArray("bombNotes");
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("fakeBombNotes")) {
            rawBombNotes.addAll(customData.getAsJsonArray("fakeBombNotes"));
        }
        rawBombNotes.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BombNote note = new BombNote().loadV3(obj, this);
            this.bombNotes.add(new PhysicalBombNote(note));
        });
    }

    void loadChains(JsonObject json) {
        JsonArray rawChainsData = json.getAsJsonArray("burstSliders");
        rawChainsData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            class_3545<ChainNoteHead, List<ChainNoteLink>> chain = ChainNoteHead.buildV3(obj, this);
            this.chainHeadNotes.add(new PhysicalChainNoteHead((ChainNoteHead)chain.method_15442()));
            ((List)chain.method_15441()).forEach(c -> this.chainLinkNotes.add(new PhysicalChainNoteLink((ChainNoteLink)c)));
        });
    }

    void loadArcs(JsonObject json) {
        JsonArray rawArcs = json.getAsJsonArray("sliders");
        rawArcs.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Arc arc = new Arc().loadV3(obj, this);
            this.arcs.add(new PhysicalArc(arc));
        });
    }

    void loadObstacles(JsonObject json) {
        JsonArray rawObstacles = json.getAsJsonArray("obstacles");
        rawObstacles.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Obstacle obstacle = new Obstacle().loadV3(obj, this);
            this.obstacles.add(new PhysicalObstacle(obstacle));
        });
    }

    void loadBasicEvents(JsonObject json) {
        JsonArray events = json.getAsJsonArray("basicBeatmapEvents");
        events.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            EventGroup group = EventGroup.fromType(obj.get("et").getAsInt());
            if (group == EventGroup.EARLY_ROTATION) {
                this.rotationEvents.add(new RotationEvent(true).fromBasicEventV3(obj, this));
            } else if (group == EventGroup.LATE_ROTATION) {
                this.rotationEvents.add(new RotationEvent(false).fromBasicEventV3(obj, this));
            }
        });
    }

    void loadRotationEvents(JsonObject json) {
        JsonArray events = json.getAsJsonArray("rotationEvents");
        events.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            boolean early = obj.get("e").getAsInt() == 1;
            this.rotationEvents.add(new RotationEvent(early).loadV3(obj, this));
        });
    }

    private void loadPointDefinitions(JsonObject json) {
        JsonObject customData;
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("pointDefinitions")) {
            JsonObject pointDefinitions = customData.getAsJsonObject("pointDefinitions");
            pointDefinitions.asMap().forEach((name, points) -> this.pointDefinitions.put(name, points.getAsJsonArray()));
        }
    }

    private void loadCustomEvents(JsonObject json) {
        JsonObject customData;
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("customEvents")) {
            JsonArray customEvents = customData.getAsJsonArray("customEvents");
            customEvents.forEach(o -> this.loadCustomEvent(o.getAsJsonObject()));
        }
    }

    private void loadCustomEvent(JsonObject json) {
        String type;
        switch (type = json.get("t").getAsString()) {
            case "AnimateTrack": {
                this.animateTracks.add(new AnimateTrack().loadV3(json, this));
                break;
            }
            case "AssignPathAnimation": {
                this.assignPathAnimations.add(new AssignPathAnimation().loadV3(json, this));
                break;
            }
            case "AssignTrackParent": {
                this.assignTrackParents.add(new AssignTrackParent().loadV3(json, this));
            }
        }
    }

    private void loadLightshow(JsonObject json) {
        this.lightShowEnvironment = EnvironmentUtils.load(this, json);
    }
}

