/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.object.Arc;
import com.beatcraft.beatmap.data.object.BombNote;
import com.beatcraft.beatmap.data.object.ChainNoteHead;
import com.beatcraft.beatmap.data.object.ChainNoteLink;
import com.beatcraft.beatmap.data.object.ColorNote;
import com.beatcraft.beatmap.data.object.Obstacle;
import com.beatcraft.lightshow.environment.EnvironmentUtils;
import com.beatcraft.render.object.PhysicalArc;
import com.beatcraft.render.object.PhysicalBombNote;
import com.beatcraft.render.object.PhysicalChainNoteHead;
import com.beatcraft.render.object.PhysicalChainNoteLink;
import com.beatcraft.render.object.PhysicalColorNote;
import com.beatcraft.render.object.PhysicalObstacle;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;

@Environment(value=EnvType.CLIENT)
public class DifficultyV4
extends Difficulty {
    public DifficultyV4(Info info, Info.SetDifficulty setDifficulty) {
        super(info, setDifficulty);
    }

    DifficultyV4 load(JsonObject json) {
        this.loadChains(json);
        this.loadNotes(json);
        this.loadBombs(json);
        this.loadObstacles(json);
        this.loadArcs(json);
        this.loadLightshow();
        this.doPostLoad();
        return this;
    }

    void loadNotes(JsonObject json) {
        JsonArray noteMetaData = json.getAsJsonArray("colorNotesData");
        JsonArray noteData = json.getAsJsonArray("colorNotes");
        noteData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            ColorNote note = new ColorNote().loadV4(obj, noteMetaData, this);
            AtomicBoolean canAdd = new AtomicBoolean(true);
            this.chainHeadNotes.forEach(c -> {
                if (note.getBeat() == ((ChainNoteHead)c.getData()).getBeat() && note.getX() == ((ChainNoteHead)c.getData()).getX() && note.getY() == ((ChainNoteHead)c.getData()).getY()) {
                    canAdd.set(false);
                }
            });
            if (canAdd.get()) {
                this.colorNotes.add(new PhysicalColorNote(note));
            }
        });
    }

    void loadBombs(JsonObject json) {
        JsonArray bombMetaData = json.getAsJsonArray("bombNotesData");
        JsonArray bombData = json.getAsJsonArray("bombNotes");
        bombData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BombNote bomb = new BombNote().loadV4(obj, bombMetaData, this);
            this.bombNotes.add(new PhysicalBombNote(bomb));
        });
    }

    void loadObstacles(JsonObject json) {
        JsonArray obstacleMetaData = json.getAsJsonArray("obstaclesData");
        JsonArray obstacles = json.getAsJsonArray("obstacles");
        obstacles.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Obstacle obstacle = new Obstacle().loadV4(obj, obstacleMetaData, this);
            this.obstacles.add(new PhysicalObstacle(obstacle));
        });
    }

    void loadChains(JsonObject json) {
        JsonArray noteMetaData = json.getAsJsonArray("colorNotesData");
        JsonArray chainMetaData = json.getAsJsonArray("chainsData");
        JsonArray chainData = json.getAsJsonArray("chains");
        chainData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            class_3545<ChainNoteHead, List<ChainNoteLink>> chain = ChainNoteHead.buildV4(obj, noteMetaData, chainMetaData, this);
            this.chainHeadNotes.add(new PhysicalChainNoteHead((ChainNoteHead)chain.method_15442()));
            ((List)chain.method_15441()).forEach(c -> this.chainLinkNotes.add(new PhysicalChainNoteLink((ChainNoteLink)c)));
        });
    }

    void loadArcs(JsonObject json) {
        JsonArray arcMetaData = json.getAsJsonArray("arcsData");
        JsonArray colorNotesData = json.getAsJsonArray("colorNotesData");
        JsonArray rawArcs = json.getAsJsonArray("arcs");
        rawArcs.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Arc arc = new Arc().loadV4(obj, arcMetaData, colorNotesData, this);
            this.arcs.add(new PhysicalArc(arc));
        });
    }

    private void loadLightshow() {
        String path = this.getSetDifficulty().getLightshowFile();
        if (path == null) {
            return;
        }
        path = (this.getInfo().getMapDirectory() + "/" + path).replace("\\", "/");
        try {
            String jsonString = Files.readString(Paths.get(path, new String[0]));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            this.lightShowEnvironment = EnvironmentUtils.load(this, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

