/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.CutDirection;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.data.types.Color;
import com.beatcraft.render.object.PhysicalColorNote;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Arc
extends GameplayObject {
    private CutDirection headCutDirection;
    private float headMagnitude;
    private CutDirection tailCutDirection;
    private float tailMagnitude;
    private float tailBeat;
    private float tailX;
    private float tailY;
    private MidAnchorMode midAnchorMode;
    private boolean _hasHeadNote = false;
    private boolean _hasTailNote = false;
    private PhysicalColorNote headNote = null;
    private PhysicalColorNote tailNote = null;
    private NoteType noteType;
    private Color color;

    private void applyColorScheme(Info.SetDifficulty setDifficulty) {
        this.color = this.noteType == NoteType.RED ? setDifficulty.getColorScheme().getNoteLeftColor() : setDifficulty.getColorScheme().getNoteRightColor();
    }

    private void checkForNotes(float b, float x, float y, float tb, float tx, float ty, Difficulty difficulty) {
        difficulty.colorNotes.forEach(c -> {
            if (c.getData().getBeat() == b && c.getData().getX() == x && c.getData().getY() == y) {
                this._hasHeadNote = true;
                this.headNote = c;
            }
            if (c.getData().getBeat() == tb && c.getData().getX() == tx && c.getData().getY() == ty) {
                this._hasTailNote = true;
                this.tailNote = c;
            }
        });
    }

    @Override
    public Arc loadV2(JsonObject json, Difficulty difficulty) {
        this.noteType = NoteType.values()[json.get("_colorType").getAsInt()];
        this.beat = json.get("_headTime").getAsFloat();
        this.tailBeat = json.get("_tailTime").getAsFloat();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.x = json.get("_headLineIndex").getAsFloat();
        this.y = json.get("_headLineLayer").getAsFloat();
        this.tailX = json.get("_tailLineIndex").getAsFloat();
        this.tailY = json.get("_tailLineLayer").getAsFloat();
        this.headCutDirection = CutDirection.values()[json.get("_headCutDirection").getAsInt()];
        this.tailCutDirection = CutDirection.values()[json.get("_tailCutDirection").getAsInt()];
        this.headMagnitude = json.get("_headControlPointLengthMultiplier").getAsFloat();
        this.tailMagnitude = json.get("_tailControlPointLengthMultiplier").getAsFloat();
        this.midAnchorMode = MidAnchorMode.values()[json.get("_sliderMidAnchorMode").getAsInt()];
        this.checkForNotes(this.beat, this.x, this.y, this.tailBeat, this.tailX, this.tailY, difficulty);
        this.loadJumps(difficulty.getInfo());
        this.applyColorScheme(difficulty.getSetDifficulty());
        return this;
    }

    @Override
    public Arc loadV3(JsonObject json, Difficulty difficulty) {
        this.noteType = NoteType.values()[JsonUtil.getOrDefault(json, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailBeat = JsonUtil.getOrDefault(json, "tb", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.x = JsonUtil.getOrDefault(json, "x", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.y = JsonUtil.getOrDefault(json, "y", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailX = JsonUtil.getOrDefault(json, "tx", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailY = JsonUtil.getOrDefault(json, "ty", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.headCutDirection = CutDirection.values()[JsonUtil.getOrDefault(json, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        this.tailCutDirection = CutDirection.values()[JsonUtil.getOrDefault(json, "tc", JsonElement::getAsInt, Integer.valueOf(0))];
        this.headMagnitude = JsonUtil.getOrDefault(json, "mu", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailMagnitude = JsonUtil.getOrDefault(json, "tmu", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.midAnchorMode = MidAnchorMode.values()[JsonUtil.getOrDefault(json, "m", JsonElement::getAsInt, Integer.valueOf(0))];
        this.checkForNotes(this.beat, this.x, this.y, this.tailBeat, this.tailX, this.tailY, difficulty);
        this.loadJumps(difficulty.getInfo());
        this.applyColorScheme(difficulty.getSetDifficulty());
        return this;
    }

    public Arc loadV4(JsonObject json, JsonArray arcsData, JsonArray colorNotesData, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "hb", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailBeat = JsonUtil.getOrDefault(json, "tb", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.offset = difficulty.getSetDifficulty().getOffset();
        int arcDataIndex = JsonUtil.getOrDefault(json, "ai", JsonElement::getAsInt, Integer.valueOf(0));
        int headNoteDataIndex = JsonUtil.getOrDefault(json, "hi", JsonElement::getAsInt, Integer.valueOf(0));
        int tailNoteDataIndex = JsonUtil.getOrDefault(json, "ti", JsonElement::getAsInt, Integer.valueOf(0));
        JsonObject arcMetaData = arcsData.get(arcDataIndex).getAsJsonObject();
        JsonObject headMetaData = colorNotesData.get(headNoteDataIndex).getAsJsonObject();
        JsonObject tailMetaData = colorNotesData.get(tailNoteDataIndex).getAsJsonObject();
        this.x = JsonUtil.getOrDefault(headMetaData, "x", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.y = JsonUtil.getOrDefault(headMetaData, "y", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.noteType = NoteType.values()[JsonUtil.getOrDefault(headMetaData, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        this.headCutDirection = CutDirection.values()[JsonUtil.getOrDefault(headMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        this.tailX = JsonUtil.getOrDefault(tailMetaData, "x", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailY = JsonUtil.getOrDefault(tailMetaData, "y", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.tailCutDirection = CutDirection.values()[JsonUtil.getOrDefault(tailMetaData, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        this.headMagnitude = JsonUtil.getOrDefault(arcMetaData, "m", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.tailMagnitude = JsonUtil.getOrDefault(arcMetaData, "tm", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.midAnchorMode = MidAnchorMode.values()[JsonUtil.getOrDefault(arcMetaData, "a", JsonElement::getAsInt, Integer.valueOf(0))];
        this.checkForNotes(this.beat, this.x, this.y, this.tailBeat, this.tailX, this.tailY, difficulty);
        this.loadJumps(difficulty.getInfo());
        this.applyColorScheme(difficulty.getSetDifficulty());
        return this;
    }

    public static Vector3f cutDirectionToControlPoint(CutDirection cutDirection) {
        return switch (cutDirection) {
            default -> throw new MatchException(null, null);
            case CutDirection.UP -> new Vector3f(0.0f, 1.0f, -1.0E-5f);
            case CutDirection.DOWN -> new Vector3f(0.0f, -1.0f, -1.0E-5f);
            case CutDirection.RIGHT -> new Vector3f(-1.0f, 0.0f, -1.0E-5f);
            case CutDirection.LEFT -> new Vector3f(1.0f, 0.0f, -1.0E-5f);
            case CutDirection.UP_RIGHT -> new Vector3f(-0.70710677f, 0.70710677f, -1.0E-5f);
            case CutDirection.UP_LEFT -> new Vector3f(0.70710677f, 0.70710677f, -1.0E-5f);
            case CutDirection.DOWN_RIGHT -> new Vector3f(-0.70710677f, -0.70710677f, -1.0E-5f);
            case CutDirection.DOWN_LEFT -> new Vector3f(0.70710677f, -0.70710677f, -1.0E-5f);
            case CutDirection.DOT -> new Vector3f(0.0f, 0.0f, 0.0f);
        };
    }

    public Color getColor() {
        return this.color;
    }

    public float getTailX() {
        return this.tailX;
    }

    public float getTailY() {
        return this.tailY;
    }

    public float getTailBeat() {
        return this.tailBeat;
    }

    public CutDirection getTailCutDirection() {
        return this.tailCutDirection;
    }

    public CutDirection getHeadCutDirection() {
        return this.headCutDirection;
    }

    public float getHeadMagnitude() {
        return this.headMagnitude;
    }

    public float getTailMagnitude() {
        return this.tailMagnitude;
    }

    public boolean hasHeadNote() {
        return this._hasHeadNote;
    }

    public boolean hasTailNote() {
        return this._hasTailNote;
    }

    public PhysicalColorNote getHeadNote() {
        return this.headNote;
    }

    public PhysicalColorNote getTailNote() {
        return this.tailNote;
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public MidAnchorMode getMidAnchorMode() {
        return this.midAnchorMode;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum MidAnchorMode {
        STRAIGHT,
        CLOCKWISE,
        COUNTER_CLOCKWISE;

    }
}

