/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.IBeatmapData;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class BeatmapObject
implements IBeatmapData<BeatmapObject> {
    protected float beat = 0.0f;

    @Override
    public BeatmapObject loadV2(JsonObject json, Difficulty difficulty) {
        this.beat = json.get("_time").getAsFloat();
        return this;
    }

    @Override
    public BeatmapObject loadV3(JsonObject json, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        return this;
    }

    public float getBeat() {
        return this.beat;
    }
}

