/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.data.types.Color;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BombNote
extends GameplayObject {
    private Color color = new Color(0.2f, 0.2f, 0.2f);

    @Override
    public BombNote loadV2(JsonObject json, Difficulty difficulty) {
        JsonObject customData;
        super.loadV2(json, difficulty);
        if (json.has("_customData") && (customData = json.get("_customData").getAsJsonObject()).has("_color")) {
            this.color = Color.fromJsonArray(customData.get("_color").getAsJsonArray());
        }
        return this;
    }

    @Override
    public BombNote loadV3(JsonObject json, Difficulty difficulty) {
        JsonObject customData;
        super.loadV3(json, difficulty);
        if (json.has("customData") && (customData = json.get("customData").getAsJsonObject()).has("color")) {
            this.color = Color.fromJsonArray(customData.get("color").getAsJsonArray());
        }
        return this;
    }

    @Override
    public BombNote loadV4(JsonObject json, JsonArray colorNoteData, Difficulty difficulty) {
        super.loadV4(json, colorNoteData, difficulty);
        return this;
    }

    public Color getColor() {
        return this.color;
    }
}

