/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.beatmap.data.object;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.Info;
import com.beatcraft.beatmap.data.CutDirection;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.beatmap.data.object.ScorableObject;
import com.beatcraft.data.types.Color;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ChainNoteLink
extends GameplayObject
implements ScorableObject {
    private float angleOffset = 0.0f;
    private NoteType noteType;
    private Color color;
    private boolean disableNoteLook = false;
    private boolean disableNoteGravity = false;

    private void applyColorScheme(Info.SetDifficulty setDifficulty) {
        this.color = this.noteType == NoteType.RED ? setDifficulty.getColorScheme().getNoteLeftColor() : setDifficulty.getColorScheme().getNoteRightColor();
    }

    @Override
    public ChainNoteLink loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.noteType = NoteType.values()[JsonUtil.getOrDefault(json, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        this.applyColorScheme(difficulty.getSetDifficulty());
        return this;
    }

    public ChainNoteLink loadV4(JsonObject json, JsonArray chainMetaData, NoteType color, Difficulty difficulty) {
        this.noteType = color;
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs();
        this.applyColorScheme(difficulty.getSetDifficulty());
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    public void setAngleOffset(float angle) {
        this.angleOffset = angle;
    }

    public void setPos(Vector3f pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.beat = pos.z;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    public CutDirection getCutDirection() {
        return CutDirection.DOT;
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isNoteLookDisable() {
        return this.disableNoteLook;
    }

    public boolean isNoteGravityDisabled() {
        return this.disableNoteGravity;
    }

    @Override
    public NoteType score$getNoteType() {
        return this.getNoteType();
    }

    @Override
    public CutDirection score$getCutDirection() {
        return this.getCutDirection();
    }
}

