/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data;

import com.beatcraft.BeatCraft;
import com.beatcraft.data.ControllerProfile;
import com.beatcraft.data.types.Stash;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PlayerConfig {
    public final File configFile = new File("./config/beatcraft/config.json");
    public final File configFolder = new File("./config/beatcraft/");
    private float audio_volume = 1.0f;
    private float audio_ambientVolumeScale = 0.8f;
    private int audio_latency = 0;
    private boolean audio_overrideLatency = false;
    private boolean quality_doBloomfog = true;
    private boolean quality_doBloom = true;
    private boolean quality_doMirror = true;
    private boolean quality_skyFog = true;
    private boolean quality_smokeGraphics = true;
    private boolean quality_burnMarkTrails = true;
    private boolean quality_sparkParticles = true;
    private final ArrayList<String> activeModifiers = new ArrayList();
    private int controller_selectedProfile_index = -1;
    private final ArrayList<ControllerProfile> profiles = new ArrayList();
    private static final ControllerProfile DEFAULT_CONTROLLER_PROFILE = new ControllerProfile();
    private boolean option_reducedDebris = false;
    private int option_trailIntensity = 30;
    private HealthStyle option_healthStyle = HealthStyle.Hearts;
    private boolean setting_placeEnvironmentStructures = true;
    private boolean debug_lightshow_doEventRendering = false;
    private float debug_lightshow_beatSpacing = 8.0f;
    private float debug_lightshow_lookAheadDistance = 16.0f;
    private float debug_lightshow_lookBehindDistance = 8.0f;

    public PlayerConfig(JsonObject json) {
        this();
        this.audio_volume = JsonUtil.getOrDefault(json, "audio.volume", JsonElement::getAsFloat, Float.valueOf(this.audio_volume)).floatValue();
        this.audio_ambientVolumeScale = JsonUtil.getOrDefault(json, "audio.ambient_volume_scale", JsonElement::getAsFloat, Float.valueOf(this.audio_ambientVolumeScale)).floatValue();
        this.audio_latency = JsonUtil.getOrDefault(json, "audio.latency", JsonElement::getAsInt, Integer.valueOf(this.audio_latency));
        this.audio_overrideLatency = JsonUtil.getOrDefault(json, "audio.override_latency", JsonElement::getAsBoolean, Boolean.valueOf(this.audio_overrideLatency));
        this.quality_doBloomfog = JsonUtil.getOrDefault(json, "quality.bloomfog", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_doBloomfog));
        this.quality_doBloom = JsonUtil.getOrDefault(json, "quality.bloom", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_doBloom));
        this.quality_doMirror = JsonUtil.getOrDefault(json, "quality.mirror", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_doMirror));
        this.quality_skyFog = JsonUtil.getOrDefault(json, "quality.sky_fog", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_skyFog));
        this.quality_smokeGraphics = JsonUtil.getOrDefault(json, "quality.smoke_graphics", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_smokeGraphics));
        this.quality_burnMarkTrails = JsonUtil.getOrDefault(json, "quality.burn_mark_trails", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_burnMarkTrails));
        this.quality_sparkParticles = JsonUtil.getOrDefault(json, "quality.spark_particles", JsonElement::getAsBoolean, Boolean.valueOf(this.quality_sparkParticles));
        this.option_reducedDebris = JsonUtil.getOrDefault(json, "option.reduced_debris", JsonElement::getAsBoolean, Boolean.valueOf(this.option_reducedDebris));
        this.option_trailIntensity = JsonUtil.getOrDefault(json, "option.trail_intensity", JsonElement::getAsInt, Integer.valueOf(this.option_trailIntensity));
        this.option_healthStyle = HealthStyle.values()[Math.clamp((long)JsonUtil.getOrDefault(json, "option.health_style", JsonElement::getAsInt, Integer.valueOf(0)).intValue(), 0, HealthStyle.values().length - 1)];
        this.debug_lightshow_doEventRendering = JsonUtil.getOrDefault(json, "debug.lightshow.render_events", JsonElement::getAsBoolean, Boolean.valueOf(this.debug_lightshow_doEventRendering));
        this.debug_lightshow_lookAheadDistance = JsonUtil.getOrDefault(json, "debug.lightshow.look_ahead", JsonElement::getAsFloat, Float.valueOf(this.debug_lightshow_lookAheadDistance)).floatValue();
        this.debug_lightshow_lookBehindDistance = JsonUtil.getOrDefault(json, "debug.lightshow.look_behind", JsonElement::getAsFloat, Float.valueOf(this.debug_lightshow_lookBehindDistance)).floatValue();
        this.debug_lightshow_beatSpacing = JsonUtil.getOrDefault(json, "debug.lightshow.beat_spacing", JsonElement::getAsFloat, Float.valueOf(this.debug_lightshow_beatSpacing)).floatValue();
        Stash.updateTrailSize(this.option_trailIntensity);
        if (json.has("active_modifiers")) {
            JsonArray rawModifiers = json.getAsJsonArray("active_modifiers");
            rawModifiers.forEach(mod -> this.activeModifiers.add(mod.getAsString()));
        }
        this.controller_selectedProfile_index = JsonUtil.getOrDefault(json, "controller.selectedProfile.index", JsonElement::getAsInt, Integer.valueOf(this.controller_selectedProfile_index));
        this.setting_placeEnvironmentStructures = JsonUtil.getOrDefault(json, "setting.placeEnvironmentStructures", JsonElement::getAsBoolean, Boolean.valueOf(this.setting_placeEnvironmentStructures));
        if (json.has("controller.profiles")) {
            JsonArray rawProfiles = json.getAsJsonArray("controller.profiles");
            rawProfiles.forEach(rawProfile -> {
                JsonObject profileData = rawProfile.getAsJsonObject();
                ControllerProfile profile = new ControllerProfile(profileData);
                this.profiles.add(profile);
            });
        }
    }

    private void writeJson(JsonObject json) {
        json.addProperty("audio.volume", (Number)Float.valueOf(this.audio_volume));
        json.addProperty("audio.ambient_volume_scale", (Number)Float.valueOf(this.audio_ambientVolumeScale));
        json.addProperty("audio.latency", (Number)this.audio_latency);
        json.addProperty("audio.override_latency", Boolean.valueOf(this.audio_overrideLatency));
        json.addProperty("quality.bloomfog", Boolean.valueOf(this.quality_doBloomfog));
        json.addProperty("quality.bloom", Boolean.valueOf(this.quality_doBloom));
        json.addProperty("quality.mirror", Boolean.valueOf(this.quality_doMirror));
        json.addProperty("quality.sky_fog", Boolean.valueOf(this.quality_skyFog));
        json.addProperty("quality.smoke_graphics", Boolean.valueOf(this.quality_smokeGraphics));
        json.addProperty("quality.burn_mark_trails", Boolean.valueOf(this.quality_burnMarkTrails));
        json.addProperty("quality.spark_particles", Boolean.valueOf(this.quality_sparkParticles));
        json.addProperty("option.reduced_debris", Boolean.valueOf(this.option_reducedDebris));
        json.addProperty("option.trail_intensity", (Number)this.option_trailIntensity);
        json.addProperty("option.health_style", (Number)this.option_healthStyle.ordinal());
        json.addProperty("debug.lightshow.render_events", Boolean.valueOf(this.debug_lightshow_doEventRendering));
        json.addProperty("debug.lightshow.look_ahead", (Number)Float.valueOf(this.debug_lightshow_lookAheadDistance));
        json.addProperty("debug.lightshow.look_behind", (Number)Float.valueOf(this.debug_lightshow_lookBehindDistance));
        json.addProperty("debug.lightshow.beat_spacing", (Number)Float.valueOf(this.debug_lightshow_beatSpacing));
        json.addProperty("controller.selectedProfile.index", (Number)this.controller_selectedProfile_index);
        json.addProperty("setting.placeEnvironmentStructures", Boolean.valueOf(this.setting_placeEnvironmentStructures));
        JsonArray array = new JsonArray();
        this.profiles.forEach(profile -> profile.writeJson(array));
        json.add("controller.profiles", (JsonElement)array);
        JsonArray array2 = new JsonArray();
        this.activeModifiers.forEach(arg_0 -> ((JsonArray)array2).add(arg_0));
        json.add("active_modifiers", (JsonElement)array2);
    }

    public PlayerConfig() {
        if (!this.configFile.exists()) {
            boolean bl = this.configFolder.mkdirs();
        }
        if (!this.configFile.exists()) {
            try {
                boolean ignored = this.configFile.createNewFile();
                this.writeToFile();
            }
            catch (IOException e) {
                BeatCraft.LOGGER.error("Error creating player config file: ", (Throwable)e);
            }
        }
    }

    public void setModifier(String modifier, boolean active) {
        if (active && !this.activeModifiers.contains(modifier)) {
            this.activeModifiers.add(modifier);
        } else if (!active) {
            this.activeModifiers.remove(modifier);
        }
    }

    public List<String> getActiveModifiers() {
        return this.activeModifiers;
    }

    public boolean isModifierActive(String modifier) {
        return this.activeModifiers.contains(modifier);
    }

    public void setVolume(float volume) {
        this.audio_volume = volume;
    }

    public float getVolume() {
        return this.audio_volume;
    }

    public float getAmbientAudioScale() {
        return this.audio_ambientVolumeScale;
    }

    public int getLatency() {
        if (this.audio_overrideLatency) {
            return this.audio_latency;
        }
        return 0;
    }

    public void setOverrideLatency(boolean enabled) {
        this.audio_overrideLatency = enabled;
    }

    public boolean getOverrideLatency() {
        return this.audio_overrideLatency;
    }

    public void setLatency(long nanos) {
        this.audio_latency = (int)(nanos * 1000000L);
    }

    public void setSmokeRendering(boolean value) {
        this.quality_smokeGraphics = value;
    }

    public boolean shouldRenderSmoke() {
        return this.quality_smokeGraphics;
    }

    public void setBurnMarkRendering(boolean value) {
        this.quality_burnMarkTrails = value;
    }

    public boolean shouldRenderBurnMarkTrails() {
        return this.quality_burnMarkTrails;
    }

    public void setReducedDebris(boolean value) {
        this.option_reducedDebris = value;
    }

    public boolean isReducedDebris() {
        return this.option_reducedDebris;
    }

    public void setSparkParticles(boolean value) {
        this.quality_sparkParticles = value;
    }

    public boolean doSparkParticles() {
        return this.quality_sparkParticles;
    }

    public boolean doEnvironmentPlacing() {
        return this.setting_placeEnvironmentStructures;
    }

    public void setEnvironmentPlacing(boolean value) {
        this.setting_placeEnvironmentStructures = value;
    }

    public void setTrailIntensity(int value) {
        this.option_trailIntensity = value;
        Stash.updateTrailSize(value);
    }

    public int getTrailIntensity() {
        return this.option_trailIntensity;
    }

    public void setBloomfogEnabled(boolean value) {
        this.quality_doBloomfog = value;
    }

    public boolean doBloomfog() {
        return this.quality_doBloomfog;
    }

    public void setBloomEnabled(boolean value) {
        this.quality_doBloom = value;
    }

    public boolean doBloom() {
        return this.quality_doBloom;
    }

    public void setMirrorEnabled(boolean value) {
        this.quality_doMirror = value;
    }

    public boolean doMirror() {
        return this.quality_doMirror;
    }

    public void setSkyFogEnabled(boolean value) {
        this.quality_skyFog = value;
    }

    public boolean doSkyFog() {
        return this.quality_skyFog;
    }

    public HealthStyle getHealthStyle() {
        return this.option_healthStyle;
    }

    public void setHealthStyle(HealthStyle style) {
        this.option_healthStyle = style;
    }

    public void setHealthStyle(int style) {
        this.option_healthStyle = HealthStyle.values()[Math.clamp((long)style, 0, HealthStyle.values().length - 1)];
    }

    public void setLightshowEventRendering(boolean state) {
        this.debug_lightshow_doEventRendering = state;
    }

    public boolean doLightshowEventRendering() {
        return this.debug_lightshow_doEventRendering;
    }

    public float getDebugLightshowLookAhead() {
        return this.debug_lightshow_lookAheadDistance;
    }

    public void setDebugLightshowLookAhead(float value) {
        this.debug_lightshow_lookAheadDistance = Math.max(1.0f, value);
    }

    public float getDebugLightshowLookBehind() {
        return this.debug_lightshow_lookBehindDistance;
    }

    public void setDebugLightshowLookBehind(float value) {
        this.debug_lightshow_lookBehindDistance = Math.max(1.0f, value);
    }

    public float getDebugLightshowBeatSpacing() {
        return this.debug_lightshow_beatSpacing;
    }

    public void setDebugLightshowBeatSpacing(float value) {
        this.debug_lightshow_beatSpacing = Math.max(1.0f, value);
    }

    public ControllerProfile getActiveControllerProfile() {
        if (this.profiles.isEmpty() || this.controller_selectedProfile_index <= -1) {
            return DEFAULT_CONTROLLER_PROFILE;
        }
        return this.profiles.get(this.controller_selectedProfile_index);
    }

    public int getSelectedControllerProfileIndex() {
        return this.controller_selectedProfile_index;
    }

    public void selectProfile(int index) {
        this.controller_selectedProfile_index = Math.clamp((long)index, -1, this.profiles.size() - 1);
    }

    public int getProfileCount() {
        return this.profiles.size();
    }

    public void addProfile() {
        ControllerProfile profile = new ControllerProfile();
        this.profiles.add(profile);
    }

    public void deleteControllerProfile(int index) {
        if (0 <= index && index < this.profiles.size()) {
            this.profiles.remove(index);
        }
    }

    public static PlayerConfig loadFromFile() {
        try {
            String jsonString = Files.readString(Path.of("./config/beatcraft/config.json", new String[0]));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return new PlayerConfig(json);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to load player config! ", (Throwable)e);
            return new PlayerConfig();
        }
    }

    public void writeToFile() {
        try {
            JsonObject json = new JsonObject();
            this.writeJson(json);
            Files.writeString(Path.of("./config/beatcraft/config.json", new String[0]), (CharSequence)json.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to save player config ", (Throwable)e);
        }
    }

    public static enum HealthStyle {
        Classic,
        Hearts;

    }
}

