/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data.menu;

import com.beatcraft.BeatCraft;
import com.beatcraft.data.menu.song_preview.SongPreview;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;

public class SongDownloader {
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final String LATEST_URL = "https://api.beatsaver.com/maps/latest";
    private static final String SEARCH_URL = "https://api.beatsaver.com/search/v1/";
    private static final String MAP_ID_URL = "https://api.beatsaver.com/maps/id/";
    private static final int PAGE_SIZE = 20;
    public static String search = "";
    public static String before = null;
    public static AutomapperOption automapper = AutomapperOption.NO_AI;
    public static int page = 0;
    public static OrderSort order = OrderSort.None;
    public static ArrayList<SongPreview> songPreviews = new ArrayList();
    public static LeaderBoardSort leaderBoardSort = LeaderBoardSort.All;
    public static Boolean noodle = null;
    public static Boolean chroma = null;
    public static Boolean verified = null;
    private static CompletableFuture<Void> loadRequest = null;
    private static int currentRequestId = 0;
    public static final Lock listModifyLock = new ReentrantLock();

    public static void pageLeft(Runnable after) {
        page = Math.max(page - 1, 0);
        SongDownloader.loadFromSearch(after);
    }

    public static void pageRight(Runnable after) {
        ++page;
        SongDownloader.loadFromSearch(after);
    }

    public static void downloadSong(SongPreview preview, String runDirectory, Runnable after) {
        CompletableFuture.runAsync(() -> SongDownloader._downloadSong(preview, runDirectory)).thenRun(after);
    }

    public static void downloadFromId(String id, String runDirectory, Runnable after) {
        CompletableFuture.runAsync(() -> SongDownloader._downloadFromId(id, runDirectory, after));
    }

    private static void _downloadFromId(String id, String runDirectory, Runnable after) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MAP_ID_URL + id)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                BeatCraft.LOGGER.error("Failed to download song '{}'", (Object)id);
                return;
            }
            String rawJson = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawJson).getAsJsonObject();
            SongPreview preview = SongPreview.loadJson(responseJson);
            SongDownloader._downloadSong(preview, runDirectory);
            String songFolder = runDirectory + "/beatmaps/" + preview.id() + " (" + SongDownloader.filterString(preview.metaData().songName() + " - " + preview.metaData().levelAuthorName()) + ")";
            if (new File(songFolder).exists()) {
                after.run();
            } else {
                BeatCraft.LOGGER.error("Something went wrong with processing downloaded song!");
            }
        }
        catch (IOException | InterruptedException e) {
            BeatCraft.LOGGER.error("Failed to download song '{}'", (Object)id, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    public static String filterString(String in) {
        String replaced = in.replaceAll("[^a-zA-Z0-9._\\-+()\\[\\]' ]", "_");
        if (replaced.length() > 150) {
            replaced = replaced.substring(0, 100);
        }
        return replaced;
    }

    private static void _downloadSong(SongPreview preview, String runDirectory) {
        String url = preview.versions().getFirst().downloadURL();
        String unzipTo = runDirectory + "/beatmaps/" + preview.id() + " (" + SongDownloader.filterString(preview.metaData().songName() + " - " + preview.metaData().levelAuthorName()) + ")";
        String path = unzipTo + ".zip";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            if (response.statusCode() != 200 || response.body() == null) {
                BeatCraft.LOGGER.error("Failed to download song: {}", (Object)response.statusCode());
                return;
            }
            try (FileOutputStream outputStream = new FileOutputStream(path);){
                outputStream.write(response.body());
            }
            SongDownloader.unzip(path, unzipTo);
        }
        catch (IOException | InterruptedException e) {
            BeatCraft.LOGGER.error("Failed to download song!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void unzip(String source, String destination) {
        try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(source));){
            ZipEntry zipEntry = inputStream.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.getName().endsWith(File.separator);
                Path newPath = SongDownloader.zipSlipProtect(zipEntry, Path.of(destination, new String[0]));
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(inputStream, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = inputStream.getNextEntry();
            }
            inputStream.closeEntry();
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to unzip song!", (Throwable)e);
        }
        try {
            Files.deleteIfExists(Path.of(source, new String[0]));
            SongDownloader.convertAllToPng(destination);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to remove temporary zip!", (Throwable)e);
        }
    }

    public static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public static void loadFromSearch(Runnable after) {
        int id = ++currentRequestId;
        if (loadRequest != null) {
            loadRequest.cancel(false);
        }
        loadRequest = CompletableFuture.runAsync(SongDownloader::_loadFromSearch).thenRun(() -> {
            if (id == currentRequestId) {
                after.run();
                loadRequest = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _loadFromSearch() {
        if (search.isEmpty()) {
            SongDownloader.loadLatest();
            return;
        }
        ArrayList localPreviews = new ArrayList();
        String searchQuery = SEARCH_URL + page + "?q=" + URLEncoder.encode(search, StandardCharsets.UTF_8) + "&leaderboard=" + leaderBoardSort.val();
        if (order.val() != null) {
            searchQuery = searchQuery + "&order=" + order.val();
        }
        if (noodle != null) {
            searchQuery = searchQuery + "&noodle=" + noodle;
        }
        if (chroma != null) {
            searchQuery = searchQuery + "&chroma=" + chroma;
        }
        if (verified != null) {
            searchQuery = searchQuery + "&verified=" + verified;
        }
        HttpRequest searchRequest = HttpRequest.newBuilder().uri(URI.create(searchQuery)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(searchRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                BeatCraft.LOGGER.error("Failed to find songs from BeatSaver!");
                return;
            }
            String rawJson = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawJson).getAsJsonObject();
            JsonArray docs = responseJson.getAsJsonArray("docs");
            docs.forEach(rawSongJson -> {
                JsonObject songJson = rawSongJson.getAsJsonObject();
                SongPreview preview = SongPreview.loadJson(songJson);
                localPreviews.add(preview);
            });
            listModifyLock.lock();
            try {
                songPreviews.clear();
                songPreviews.addAll(localPreviews);
            }
            finally {
                listModifyLock.unlock();
            }
        }
        catch (IOException | InterruptedException e) {
            BeatCraft.LOGGER.error("Failed to connect to BeatSaver!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static void loadLatest() {
        songPreviews.clear();
        page = 0;
        Object listQuery = "https://api.beatsaver.com/maps/latest?pageSize=20";
        if (before != null) {
            listQuery = (String)listQuery + "&before=" + before;
        }
        if (automapper.valLatest() != null) {
            listQuery = (String)listQuery + "&automapper=" + automapper.valLatest();
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)listQuery)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200 || response.body() == null) {
                BeatCraft.LOGGER.error("Failed to fetch songs from BeatSaver!");
                return;
            }
            String rawBody = response.body();
            JsonObject responseJson = JsonParser.parseString((String)rawBody).getAsJsonObject();
            JsonArray docs = responseJson.getAsJsonArray("docs");
            docs.forEach(rawSongJson -> {
                JsonObject songJson = rawSongJson.getAsJsonObject();
                SongPreview preview = SongPreview.loadJson(songJson);
                songPreviews.add(preview);
            });
        }
        catch (IOException | InterruptedException e) {
            BeatCraft.LOGGER.error("Failed to connect to BeatSaver!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void convertToPng(File inputFile, File outputFile) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputFile);
        if (originalImage == null) {
            throw new IOException("Invalid image file: " + inputFile.getAbsolutePath());
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage convertedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = convertedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(originalImage, 0, 0, width, height, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)convertedImage, "png", outputFile);
        Files.deleteIfExists(inputFile.toPath());
    }

    public static void convertAllToPng(String folder) {
        File dir = new File(folder);
        if (!dir.exists() || !dir.isDirectory()) {
            System.out.println("Invalid directory: " + folder);
            return;
        }
        File[] files = dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            String outputFileName = file.getAbsolutePath().replaceAll("(?i)\\.jpe?g$", ".png");
            File outputFile = new File(outputFileName);
            try {
                SongDownloader.convertToPng(file, outputFile);
            }
            catch (IOException e) {
                BeatCraft.LOGGER.error("Failed to convert image to png '{}'", (Object)file.getName(), (Object)e);
            }
        }
    }

    public static enum LeaderBoardSort {
        All("All"),
        Ranked("Ranked"),
        BeatLeader("BeatLeader"),
        ScoreSaber("ScoreSaber");

        private final String val;

        private LeaderBoardSort(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum OrderSort {
        None(null),
        Latest("Latest"),
        Relevance("Relevance"),
        Rating("Rating"),
        Curated("Curated"),
        Random("Random");

        private final String val;

        private OrderSort(String val) {
            this.val = val;
        }

        public String val() {
            return this.val;
        }
    }

    public static enum AutomapperOption {
        BOTH(true, true),
        AI(false, null),
        NO_AI(null, false);

        private final Boolean val;
        private final Boolean val2;

        private AutomapperOption(Boolean val, Boolean val2) {
            this.val = val;
            this.val2 = val2;
        }

        public Boolean valSearch() {
            return this.val;
        }

        public Boolean valLatest() {
            return this.val2;
        }
    }
}

