/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data.types;

import com.beatcraft.data.types.ISplinePath;
import com.beatcraft.memory.MemoryPool;
import java.util.List;
import org.joml.Vector3f;

public class BezierCurve
implements ISplinePath {
    private final Vector3f p0;
    private final Vector3f p1;
    private final Vector3f p2;

    public BezierCurve(Vector3f p0, Vector3f p1, Vector3f p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public Vector3f evaluate(float t) {
        float num = 1.0f - t;
        float x = num * num * this.p0.x + 2.0f * num * t * this.p1.x + t * t * this.p2.x;
        float y = num * num * this.p0.y + 2.0f * num * t * this.p1.y + t * t * this.p2.y;
        float z = num * num * this.p0.z + 2.0f * num * t * this.p1.z + t * t * this.p2.z;
        return MemoryPool.newVector3f(x, y, z);
    }

    @Override
    public Vector3f getTangent(float t) {
        float x = 2.0f * (1.0f - t) * (this.p1.x - this.p0.x) + 2.0f * t * (this.p2.x - this.p1.x);
        float y = 2.0f * (1.0f - t) * (this.p1.y - this.p0.y) + 2.0f * t * (this.p2.y - this.p1.y);
        float z = 2.0f * (1.0f - t) * (this.p1.z - this.p0.z) + 2.0f * t * (this.p2.z - this.p1.z);
        return MemoryPool.newVector3f(x, y, z);
    }

    @Override
    public List<Vector3f> getControlPoints() {
        return List.of(this.p0, this.p1, this.p2);
    }
}

