/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.data.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class Color {
    private float alpha = 0.0f;
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;

    public Color(float red, float green, float blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public Color(int hex) {
        int a = hex >> 24 & 0xFF;
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        float fr = (float)r / 255.0f;
        float fg = (float)g / 255.0f;
        float fb = (float)b / 255.0f;
        float fa = (float)a / 255.0f;
        this.setRed(fr);
        this.setGreen(fg);
        this.setBlue(fb);
        this.setAlpha(fa);
    }

    public Color() {
    }

    public Color copy() {
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    public static Color fromJsonObject(JsonObject json) {
        Color color = new Color();
        color.setRed(json.get("r").getAsFloat());
        color.setGreen(json.get("g").getAsFloat());
        color.setBlue(json.get("b").getAsFloat());
        color.setAlpha(1.0f);
        return color;
    }

    public static Color fromJsonArray(JsonArray json) {
        Color color = new Color();
        color.setRed(json.get(0).getAsFloat());
        color.setGreen(json.get(1).getAsFloat());
        color.setBlue(json.get(2).getAsFloat());
        if (json.size() == 4) {
            color.setAlpha(json.get(3).getAsFloat());
        } else {
            color.setAlpha(1.0f);
        }
        return color;
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color withAlpha(float alpha) {
        this.setAlpha(Math.clamp(alpha, 0.0f, 1.0f));
        return this;
    }

    public void set(Color other) {
        this.red = other.getRed();
        this.green = other.getGreen();
        this.blue = other.getBlue();
        this.alpha = other.getAlpha();
    }

    public void set(float red, float green, float blue) {
        this.set(red, green, blue, 1.0f);
    }

    public void set(float red, float green, float blue, float alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public int toARGB() {
        return this.toARGB(this.getAlpha());
    }

    public int toARGB(float alpha) {
        int color = (int)(alpha * 255.0f);
        color <<= 8;
        color += (int)(this.getRed() * 255.0f);
        color <<= 8;
        color += (int)(this.getGreen() * 255.0f);
        color <<= 8;
        return color += (int)(this.getBlue() * 255.0f);
    }

    public int lerpBrightness(float brightness) {
        float newAlpha;
        float newBlue;
        float newGreen;
        float newRed;
        float r = this.getRed();
        float g = this.getGreen();
        float b = this.getBlue();
        float a = this.getAlpha();
        if (brightness <= 1.0f) {
            newRed = r * brightness;
            newGreen = g * brightness;
            newBlue = b * brightness;
            newAlpha = a * brightness;
        } else {
            float overBright = brightness - 1.0f;
            newRed = r + (1.0f - r) * overBright;
            newGreen = g + (1.0f - g) * overBright;
            newBlue = b + (1.0f - b) * overBright;
            newAlpha = a + (1.0f - a) * overBright;
        }
        newRed = Math.clamp(newRed, 0.0f, 1.0f);
        newGreen = Math.clamp(newGreen, 0.0f, 1.0f);
        newBlue = Math.clamp(newBlue, 0.0f, 1.0f);
        newAlpha = Math.clamp(newAlpha, 0.0f, 1.0f);
        int intRed = (int)(newRed * 255.0f);
        int intGreen = (int)(newGreen * 255.0f);
        int intBlue = (int)(newBlue * 255.0f);
        int intAlpha = (int)(newAlpha * 255.0f);
        return intAlpha << 24 | intRed << 16 | intGreen << 8 | intBlue;
    }

    public String toString() {
        return "Color{, red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "alpha=" + this.alpha + "}";
    }
}

