/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.environment;

import com.beatcraft.BeatCraft;
import com.beatcraft.environment.structure_placers.EmptyStructure;
import com.beatcraft.environment.structure_placers.EnvironmentPlacer;
import com.beatcraft.environment.structure_placers.NiceStructure;
import com.beatcraft.environment.structure_placers.StripRunwayPlacer;
import com.beatcraft.environment.structure_placers.TheFirstStructure;
import com.beatcraft.environment.structure_placers.TriangleStructure;
import com.beatcraft.world.PlacedEnvironmentState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_3218;

public class StructurePlacer {
    public static String currentStructure = "";
    private static PlacedEnvironmentState worldPlacementState;
    private static final EnvironmentPlacer DEFAULT;
    private static final EnvironmentPlacer EMPTY;
    private static final EnvironmentPlacer STRIPS;
    private static final EnvironmentPlacer TRIANGLE;
    private static final EnvironmentPlacer NICE;
    private static final HashMap<String, EnvironmentPlacer> structurePlacers;

    public static void setState(PlacedEnvironmentState state) {
        worldPlacementState = state;
        currentStructure = state.getPlacedEnvironment();
    }

    public static List<String> matchEnvironments(String env) {
        ArrayList<String> matching = new ArrayList<String>();
        for (String key : structurePlacers.keySet()) {
            if (!key.contains(env)) continue;
            matching.add(key);
        }
        return matching;
    }

    public static void init() {
        structurePlacers.put("Default", DEFAULT);
        structurePlacers.put("WeaveEnvironment", EMPTY);
        structurePlacers.put("OriginsEnvironment", STRIPS);
        structurePlacers.put("TriangleEnvironment", TRIANGLE);
        structurePlacers.put("NiceEnvironment", NICE);
    }

    public static void placeStructure(String struct, class_3218 world) {
        if (!BeatCraft.isFlatWorld) {
            return;
        }
        StructurePlacer.placeStructureForced(struct, world);
    }

    public static boolean placeStructureForced(String struct, class_3218 world) {
        if (!currentStructure.equals(struct)) {
            EnvironmentPlacer current = structurePlacers.get(struct);
            if (current != null) {
                EnvironmentPlacer last = structurePlacers.get(currentStructure);
                if (last != null) {
                    last.removeStructure(world);
                }
                currentStructure = struct;
                worldPlacementState.setPlacedEnvironment(currentStructure);
                current.placeStructure(world);
            }
            return current != null;
        }
        return false;
    }

    public static boolean removeStructure(class_3218 world) {
        if (currentStructure.isEmpty()) {
            return false;
        }
        EnvironmentPlacer last = structurePlacers.getOrDefault(currentStructure, DEFAULT);
        if (last != null) {
            last.removeStructure(world);
        }
        currentStructure = "";
        worldPlacementState.setPlacedEnvironment("");
        return true;
    }

    static {
        DEFAULT = new TheFirstStructure();
        EMPTY = new EmptyStructure();
        STRIPS = new StripRunwayPlacer();
        TRIANGLE = new TriangleStructure();
        NICE = new NiceStructure();
        structurePlacers = new HashMap();
    }
}

