/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.lightshow.environment.Environment;
import com.beatcraft.lightshow.environment.EnvironmentV2;
import com.beatcraft.lightshow.environment.EnvironmentV3;
import com.beatcraft.lightshow.environment.nice.NiceEnvironment;
import com.beatcraft.lightshow.environment.origins.OriginsEnvironment;
import com.beatcraft.lightshow.environment.thefirst.TheFirstEnvironment;
import com.beatcraft.lightshow.environment.triangle.TriangleEnvironment;
import com.beatcraft.lightshow.environment.weave.WeaveEnvironment;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public class EnvironmentUtils {
    public static EnvironmentV2 theFirst = null;
    public static EnvironmentV2 origins = null;
    public static EnvironmentV2 triangle = null;
    public static EnvironmentV2 nice = null;
    public static EnvironmentV3 weave = null;

    public static Environment setupEnvironment(String environment) {
        return (switch (environment) {
            case "OriginsEnvironment" -> {
                if (origins == null) {
                    origins = new OriginsEnvironment();
                    yield origins;
                }
                yield origins;
            }
            case "TriangleEnvironment" -> {
                if (triangle == null) {
                    triangle = new TriangleEnvironment();
                    yield triangle;
                }
                yield triangle;
            }
            case "NiceEnvironment" -> {
                if (nice == null) {
                    nice = new NiceEnvironment();
                    yield nice;
                }
                yield nice;
            }
            case "WeaveEnvironment" -> {
                if (weave == null) {
                    weave = new WeaveEnvironment();
                    yield weave;
                }
                yield weave;
            }
            default -> {
                if (theFirst == null) {
                    theFirst = new TheFirstEnvironment();
                    yield theFirst;
                }
                yield theFirst;
            }
        }).reset();
    }

    public static Environment load(Difficulty difficulty, JsonObject json) {
        Environment env = EnvironmentUtils.setupEnvironment(difficulty.getInfo().getEnvironmentName());
        env.loadLightshow(difficulty, json);
        return env;
    }
}

