/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.lightgroup;

import com.beatcraft.BeatCraft;
import com.beatcraft.lightshow.environment.lightgroup.LightGroup;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.lightshow.lights.TransformState;
import com.beatcraft.render.BeatCraftRenderer;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class LightGroupV3
extends LightGroup {
    public final HashMap<Integer, LightObject> lights;

    public LightGroupV3(HashMap<Integer, LightObject> lights) {
        this.lights = lights;
    }

    public int getLightCount() {
        return this.lights.size();
    }

    public void reset() {
        this.lights.forEach((id, light) -> light.resetState());
    }

    public void setLightState(int id, LightState state) {
        if (this.lights.containsKey(id)) {
            this.lights.get(id).setLightState(state);
        } else {
            BeatCraft.LOGGER.error("LightGroupV3 setLightState: No LightObject with id {} found", (Object)id);
        }
    }

    public void setTransform(int id, TransformState state) {
        if (this.lights.containsKey(id)) {
            this.lights.get(id).setTransformState(state);
        } else {
            BeatCraft.LOGGER.error("LightGroupV setTransform3: No LightObject with id {} found", (Object)id);
        }
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        this.lights.forEach((key, light) -> light.render(matrices, camera, BeatCraftRenderer.bloomfog));
    }
}

