/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.lightgroup;

import com.beatcraft.beatmap.data.EventGroup;
import com.beatcraft.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.lightshow.event.events.ValueEvent;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.render.BeatCraftRenderer;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class RotatingLightsGroup
extends ActionLightGroupV2 {
    class_5819 random = class_5819.method_43047();
    private final List<Quaternionf> rotations;
    private final List<LightObject> rotatingLights;
    private final List<LightObject> staticLights;

    public RotatingLightsGroup(HashMap<Integer, LightObject> rotatingLights, HashMap<Integer, LightObject> staticLights) {
        super(RotatingLightsGroup.collectLights(rotatingLights, staticLights));
        this.rotatingLights = rotatingLights.values().stream().toList();
        this.staticLights = staticLights.values().stream().toList();
        this.rotations = rotatingLights.values().stream().map(o -> new Quaternionf()).toList();
    }

    private static HashMap<Integer, LightObject> collectLights(HashMap<Integer, LightObject> rotatingLights, HashMap<Integer, LightObject> staticLights) {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        lights.putAll(rotatingLights);
        lights.putAll(staticLights);
        return lights;
    }

    public static Quaternionf getYRotation(int v) {
        return new Quaternionf().rotationY((float)v);
    }

    @Override
    public void handleEvent(ValueEvent event, EventGroup eventGroup) {
        int v = event.getValue();
        this.rotations.forEach(rot -> rot.set((Quaternionfc)RotatingLightsGroup.getYRotation(v)));
        this.rotatingLights.forEach(light -> light.setRotation(v == 0 ? new Quaternionf() : new Quaternionf().rotationY((float)this.random.method_39332(-180, 180) * ((float)Math.PI / 180))));
    }

    @Override
    public void update(float beat, double deltaTime) {
        for (int i = 0; i < this.rotatingLights.size(); ++i) {
            LightObject light = this.rotatingLights.get(i);
            Quaternionf rotation = this.rotations.get(i);
            light.addRotation(new Quaternionf().slerp((Quaternionfc)rotation, (float)deltaTime));
        }
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        super.render(matrices, camera);
        this.staticLights.forEach(light -> light.render(matrices, camera, BeatCraftRenderer.bloomfog));
    }
}

