/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.nice;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.Easing;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.lightshow.environment.EnvironmentV2;
import com.beatcraft.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.lightshow.environment.lightgroup.RingLightGroup;
import com.beatcraft.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.lightshow.environment.nice.InnerRing;
import com.beatcraft.lightshow.environment.nice.OuterRing;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.spectrogram.SpectrogramTowers;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.lights.GlowingCuboid;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class NiceEnvironment
extends EnvironmentV2 {
    private RingLightGroup ringLights;
    private SpectrogramTowers leftSpectrogramTowers;
    private SpectrogramTowers rightSpectrogramTowers;
    private static final float ROTATING_LIGHT_X = 9.0f;
    private static final float ROTATING_LIGHT_Z = 35.0f;
    private static final float MIDDLE_LIGHT_Z = 60.0f;
    private static final float[] angles = new float[]{22.5f, 7.5f, -7.5f, -22.5f};
    private static final float ringRadius = 27.0f;
    private static final float lightLength = 6.0f;
    private static final float lightSize = 0.2f;

    @Override
    public String getID() {
        return "NiceEnvironment";
    }

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        super.loadLightshow(difficulty, json);
        File f = new File(difficulty.getInfo().getSongFilename());
        this.leftSpectrogramTowers = new SpectrogramTowers(new Vector3f(13.5f, -5.0f, -80.5f), new Quaternionf(), new Vector3f(0.0f, 0.0f, 2.0f), 127, f, SpectrogramTowers.TowerStyle.Cuboid, true);
        this.rightSpectrogramTowers = this.leftSpectrogramTowers.copyTo(new Vector3f(-13.5f, -5.0f, -80.5f), new Quaternionf());
        this.leftSpectrogramTowers.levelModifier = 0.75f;
        this.rightSpectrogramTowers.levelModifier = 0.75f;
        this.leftSpectrogramTowers.levelEasing = Easing::easeOutExpo;
        this.rightSpectrogramTowers.levelEasing = Easing::easeOutExpo;
    }

    private static GlowingCuboid getRunway(boolean isLeft, boolean isCenter) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -0.03f, isCenter ? 0.0f : -500.0f), new Vector3f(0.03f, 0.03f, 500.0f)), isCenter ? new Vector3f((float)(2 * sign), 0.0f, 9.0f) : new Vector3f(16.0f * (float)sign, 1.5f, 8.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight1(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -20.0f, -0.1f), new Vector3f(0.1f, 8.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 16.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight2(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -15.0f, -0.1f), new Vector3f(0.1f, 11.5f, 0.1f)), new Vector3f((float)(20 * sign), 0.0f, 19.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight3(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -20.0f, -0.1f), new Vector3f(0.1f, 8.5f, 0.1f)), new Vector3f((float)(10 * sign), -6.0f, -17.0f), new Quaternionf());
    }

    private static GlowingCuboid getTowerLight4(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -15.0f, -0.1f), new Vector3f(0.1f, 11.5f, 0.1f)), new Vector3f((float)(10 * sign), -6.0f, -14.0f), new Quaternionf());
    }

    private static GlowingCuboid[] getSkyLasers(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid[]{new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 350.0f, 0.2f)), new Vector3f(12.5f * (float)sign, 24.0f, -13.5f), new Quaternionf()), new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 350.0f, 0.2f)), new Vector3f(22.5f * (float)sign, 30.0f, 19.5f), new Quaternionf())};
    }

    private static GlowingCuboid getSlantedLaser(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.2f, 0.0f, -0.2f), new Vector3f(0.2f, 102.0f, 0.2f)), new Vector3f(3.5f * (float)sign, -64.0f, -0.5f), new Quaternionf().rotationX(-0.34557518f));
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (float angle : angles) {
            GlowingCuboid light = new GlowingCuboid(new Hitbox(new Vector3f(-300.0f, -0.03f, -0.03f), new Vector3f(300.0f, 0.03f, 0.03f)), new Vector3f(0.0f, -10.0f, 45.0f), new Quaternionf());
            light.setRotation2(new Quaternionf().rotationZ(angle * ((float)Math.PI / 180)));
            rotatingLights.put(lightID++, light);
        }
        GlowingCuboid leftRunway = NiceEnvironment.getRunway(true, false);
        GlowingCuboid leftTowerLight1 = NiceEnvironment.getTowerLight1(true);
        GlowingCuboid leftTowerLight2 = NiceEnvironment.getTowerLight2(true);
        GlowingCuboid leftTowerLight3 = NiceEnvironment.getTowerLight3(true);
        GlowingCuboid leftTowerLight4 = NiceEnvironment.getTowerLight4(true);
        GlowingCuboid[] skyLasers = NiceEnvironment.getSkyLasers(true);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID++, leftTowerLight1);
        staticLights.put(lightID++, leftTowerLight2);
        staticLights.put(lightID++, leftTowerLight3);
        staticLights.put(lightID++, leftTowerLight4);
        staticLights.put(lightID++, skyLasers[0]);
        staticLights.put(lightID++, skyLasers[1]);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (float angle : angles) {
            GlowingCuboid light = new GlowingCuboid(new Hitbox(new Vector3f(-300.0f, -0.03f, -0.03f), new Vector3f(300.0f, 0.03f, 0.03f)), new Vector3f(0.0f, 15.0f, 45.0f), new Quaternionf());
            light.setRotation2(new Quaternionf().rotationZ(angle * ((float)Math.PI / 180)));
            rotatingLights.put(lightID++, light);
        }
        GlowingCuboid rightRunway = NiceEnvironment.getRunway(false, false);
        GlowingCuboid rightTowerLight1 = NiceEnvironment.getTowerLight1(false);
        GlowingCuboid rightTowerLight2 = NiceEnvironment.getTowerLight2(false);
        GlowingCuboid rightTowerLight3 = NiceEnvironment.getTowerLight3(false);
        GlowingCuboid rightTowerLight4 = NiceEnvironment.getTowerLight4(false);
        GlowingCuboid[] skyLasers = NiceEnvironment.getSkyLasers(false);
        staticLights.put(lightID++, rightRunway);
        staticLights.put(lightID++, rightTowerLight1);
        staticLights.put(lightID++, rightTowerLight2);
        staticLights.put(lightID++, rightTowerLight3);
        staticLights.put(lightID++, rightTowerLight4);
        staticLights.put(lightID++, skyLasers[0]);
        staticLights.put(lightID++, skyLasers[1]);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 4; ++i) {
            float z = 60.0f + (float)(i * 10);
            GlowingCuboid bottomLeftLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(5.0f, -2.0f, z), new Quaternionf().rotationZ(0.2617994f));
            lights.put(lightID++, bottomLeftLaser);
            GlowingCuboid bottomRightLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, -150.0f, -0.05f), new Vector3f(0.05f, 0.0f, 0.05f)), new Vector3f(-5.0f, -2.0f, z), new Quaternionf().rotationZ(-0.2617994f));
            lights.put(lightID++, bottomRightLaser);
        }
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (int i = 0; i < 4; ++i) {
            float z = 60.0f + (float)(i * 10);
            GlowingCuboid topLeftLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(5.0f, -2.0f, z), new Quaternionf().rotationZ(0.2617994f));
            lights.put(lightID++, topLeftLaser);
            GlowingCuboid topRightLaser = new GlowingCuboid(new Hitbox(new Vector3f(-0.05f, 0.0f, -0.05f), new Vector3f(0.05f, 200.0f, 0.05f)), new Vector3f(-5.0f, -2.0f, z), new Quaternionf().rotationZ(-0.2617994f));
            lights.put(lightID++, topRightLaser);
        }
        GlowingCuboid rRunway = NiceEnvironment.getRunway(false, true);
        GlowingCuboid lRunway = NiceEnvironment.getRunway(true, true);
        lights.put(lightID++, lRunway);
        lights.put(lightID++, rRunway);
        GlowingCuboid leftSlanted = NiceEnvironment.getSlantedLaser(true);
        GlowingCuboid rightSlanted = NiceEnvironment.getSlantedLaser(false);
        lights.put(lightID++, leftSlanted);
        lights.put(lightID++, rightSlanted);
        GlowingCuboid chevronLeft = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(0.9599311f));
        lights.put(lightID++, chevronLeft);
        GlowingCuboid chevronRight = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(-0.9599311f));
        lights.put(lightID++, chevronRight);
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        this.ringLights = new RingLightGroup(InnerRing::getInstance, OuterRing::new, () -> new GlowingCuboid(new Hitbox(new Vector3f(-3.0f, -0.2f, -0.2f), new Vector3f(3.0f, 0.2f, 0.2f)), new Vector3f(0.0f, 26.79f, 0.2f), new Quaternionf()), 4.25f, 10, 30.0f, 1.25f);
        return this.ringLights;
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        super.render(matrices, camera);
        float t = BeatmapPlayer.getCurrentSeconds();
        this.leftSpectrogramTowers.render(t);
        this.rightSpectrogramTowers.render(t);
    }

    @Override
    public NiceEnvironment reset() {
        super.reset();
        this.ringLights.reset();
        return this;
    }
}

