/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.nice;

import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.Bloomfog;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class OuterRing
extends LightObject {
    private List<LightObject> lights;
    private static final float ringRadius = 27.0f;
    private static final float ringWidth = 1.0f;
    private static final float ringDepth = 0.5f;
    private static final int color = -16777216;
    private static final float lightSize = 0.2f;
    private static final float lightOffset = 0.001f;
    protected boolean lightsOnly = false;
    private static final Vector3f[] vertices = new Vector3f[]{new Vector3f(27.0f, 0.0f, 0.0f), new Vector3f(28.0f, 0.0f, 0.0f), new Vector3f(28.0f, 28.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 0.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.5f), new Vector3f(27.0f, 0.0f, 0.5f), new Vector3f(28.0f, 28.0f, 0.0f), new Vector3f(0.0f, 28.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(27.0f, 27.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.0f), new Vector3f(0.0f, 27.0f, 0.5f), new Vector3f(27.0f, 27.0f, 0.5f)};
    private static final Vector3f[] modifiers = new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f)};

    public static OuterRing getLightsOnly(BiFunction<Vector3f, Quaternionf, LightObject> lightFactory) {
        OuterRing a = new OuterRing(lightFactory);
        a.lightsOnly = true;
        return a;
    }

    public OuterRing(BiFunction<Vector3f, Quaternionf, LightObject> lightFactory) {
        this.orientation = new Quaternionf().rotationZ(0.7853982f);
        this.lights = List.of(lightFactory.apply(new Vector3f(0.0f, 26.79f, 0.201f), new Quaternionf()), lightFactory.apply(new Vector3f(26.79f, 0.0f, 0.201f), new Quaternionf().rotationZ(1.5707964f)), lightFactory.apply(new Vector3f(0.0f, -26.79f, 0.201f), new Quaternionf().rotationZ((float)Math.PI)), lightFactory.apply(new Vector3f(-26.79f, 0.0f, 0.201f), new Quaternionf().rotationZ(-1.5707964f)));
    }

    @Override
    public OuterRing cloneOffset(Vector3f offset) {
        return this;
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
        Vector3f pos = new Vector3f((Vector3fc)this.position);
        Vector3f off = new Vector3f((Vector3fc)this.offset);
        Quaternionf ori = new Quaternionf((Quaternionfc)this.orientation);
        Quaternionf rot = new Quaternionf((Quaternionfc)this.rotation);
        if (!this.lightsOnly) {
            BeatCraftRenderer.recordBloomfogPosColCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render((class_287)b, (Vector3f)c, pos, off, ori, rot, bloomfog)));
        }
        for (LightObject light : this.lights) {
            light.setWorldRotation(new Quaternionf((Quaternionfc)this.orientation).mul((Quaternionfc)this.rotation));
            light.setOffset(new Vector3f((Vector3fc)this.position).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.offset).rotate((Quaternionfc)this.worldRotation));
            light.render(matrices, camera, bloomfog);
        }
    }

    private Vector3f processVertex(Vector3f base, Vector3f pos, Vector3f off, Quaternionf ori, Quaternionf rot, Vector3f camera) {
        return new Vector3f((Vector3fc)base).rotate((Quaternionfc)ori).add((Vector3fc)pos).rotate((Quaternionfc)rot).add((Vector3fc)off).sub((Vector3fc)camera);
    }

    private void _render(class_287 buffer, Vector3f cameraPos, Vector3f position, Vector3f offset, Quaternionf orientation, Quaternionf rotation, Bloomfog bloomfog) {
        for (Vector3f mod : modifiers) {
            for (Vector3f vertex : vertices) {
                buffer.method_60830(this.processVertex(vertex.mul((Vector3fc)mod, new Vector3f()), position, offset, orientation, rotation, cameraPos)).method_39415(-16777216);
            }
        }
    }

    @Override
    public void setBrightness(float value) {
    }

    @Override
    public void setColor(int color) {
    }

    @Override
    public void setLightState(LightState state) {
    }
}

