/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.origins;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.Easing;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.lightshow.environment.EnvironmentV2;
import com.beatcraft.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.lightshow.environment.lightgroup.RingLightGroup;
import com.beatcraft.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.lightshow.environment.origins.OriginsParticleSpawner;
import com.beatcraft.lightshow.environment.thefirst.OuterRing;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.spectrogram.SpectrogramTowers;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.lights.GlowingCuboid;
import com.beatcraft.render.lights.ParticleCloudLight;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class OriginsEnvironment
extends EnvironmentV2 {
    private RingLightGroup ringLights;
    private SpectrogramTowers leftSpectrogramTowers;
    private SpectrogramTowers rightSpectrogramTowers;
    private static final float ROTATING_LIGHT_X = 20.5f;
    private static final float ROTATING_LIGHT_Z = 35.0f;
    private static final float MIDDLE_LIGHT_Z = 60.0f;
    private static final class_3545<Vector3f, Quaternionf>[] bottomLights = new class_3545[]{new class_3545((Object)new Vector3f(1.5f, -0.25f, 20.0f), (Object)new Quaternionf().rotationZ(-0.21816616f)), new class_3545((Object)new Vector3f(-1.5f, -0.25f, 20.0f), (Object)new Quaternionf().rotationZ(0.21816616f)), new class_3545((Object)new Vector3f(1.5f, -0.25f, 28.0f), (Object)new Quaternionf().rotationZ(-0.21816616f)), new class_3545((Object)new Vector3f(-1.5f, -0.25f, 28.0f), (Object)new Quaternionf().rotationZ(0.21816616f))};
    private static final float ringRadius = 30.0f;
    private static final float lightLength = 12.0f;
    private static final float lightSize = 0.2f;

    @Override
    public String getID() {
        return "OriginsEnvironment";
    }

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        super.loadLightshow(difficulty, json);
        File f = new File(difficulty.getInfo().getSongFilename());
        this.leftSpectrogramTowers = new SpectrogramTowers(new Vector3f(114.0f, -71.0f, -80.5f), new Quaternionf().rotateZ(0.7853982f).rotateLocalY(-0.21816616f), new Vector3f(0.0f, 0.0f, 2.0f), 127, f, SpectrogramTowers.TowerStyle.Cuboid, true);
        this.rightSpectrogramTowers = this.leftSpectrogramTowers.copyTo(new Vector3f(-114.0f, -71.0f, -80.5f), new Quaternionf().rotateZ(-0.7853982f).rotateLocalY(0.21816616f));
        this.leftSpectrogramTowers.levelModifier = 0.75f;
        this.rightSpectrogramTowers.levelModifier = 0.75f;
        this.leftSpectrogramTowers.baseHeight = 100.0f;
        this.rightSpectrogramTowers.baseHeight = 100.0f;
        this.leftSpectrogramTowers.levelEasing = Easing::easeOutExpo;
        this.rightSpectrogramTowers.levelEasing = Easing::easeOutExpo;
    }

    private static GlowingCuboid getRunway(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -0.03f, 0.0f), new Vector3f(0.03f, 0.03f, 500.0f)), new Vector3f(2.5f * (float)sign, 0.0f, 8.0f), new Quaternionf());
    }

    private static ParticleCloudLight getParticles(boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        Quaternionf rotation = new Quaternionf().rotationY(0.21816616f * (float)(-sign));
        ParticleCloudLight cl = new ParticleCloudLight(new Vector3f((float)(12 * sign), -5.0f, 20.0f), rotation, new Hitbox(new Vector3f(-4.0f, -5.0f, -35.0f), new Vector3f(4.0f, 3.0f, 40.0f)), 0.01f, 4.0f, 4.0f, new Vector3f(0.0f, 0.0f, 2.0f));
        cl.addParticleSpawners(new OriginsParticleSpawner());
        return cl;
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 2.25f);
        GlowingCuboid left1 = new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, 0.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(20.5f, -5.0f, 35.0f), new Quaternionf().rotationZ(0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        GlowingCuboid left5 = left4.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        rotatingLights.put(lightID++, left5);
        GlowingCuboid leftRunway = OriginsEnvironment.getRunway(true);
        ParticleCloudLight leftParticles = OriginsEnvironment.getParticles(true);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID, leftParticles);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 2.25f);
        GlowingCuboid left1 = new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, 0.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(-20.5f, -5.0f, 35.0f), new Quaternionf().rotationZ(0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        GlowingCuboid left5 = left4.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        rotatingLights.put(lightID++, left5);
        GlowingCuboid leftRunway = OriginsEnvironment.getRunway(false);
        ParticleCloudLight leftParticles = OriginsEnvironment.getParticles(false);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID, leftParticles);
        return new RotatingLightsGroup(rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (class_3545<Vector3f, Quaternionf> pair : bottomLights) {
            lights.put(lightID++, new GlowingCuboid(new Hitbox(new Vector3f(-0.03f, -100.0f, -0.03f), new Vector3f(0.03f, 0.0f, 0.03f)), (Vector3f)pair.method_15442(), (Quaternionf)pair.method_15441()));
        }
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        int lightID = 1;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        GlowingCuboid chevronLeft = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(0.9599311f));
        lights.put(lightID++, chevronLeft);
        GlowingCuboid chevronRight = new GlowingCuboid(new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(-0.9599311f));
        lights.put(lightID++, chevronRight);
        return new StaticLightsGroup(lights);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        this.ringLights = new RingLightGroup(b -> null, OuterRing::getLightsOnly, () -> new GlowingCuboid(new Hitbox(new Vector3f(-6.0f, -0.2f, -0.2f), new Vector3f(6.0f, 0.2f, 0.2f)), new Vector3f(0.0f, 29.79f, 0.2f), new Quaternionf()));
        return this.ringLights;
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        super.render(matrices, camera);
        float t = BeatmapPlayer.getCurrentSeconds();
        this.leftSpectrogramTowers.render(t);
        this.rightSpectrogramTowers.render(t);
    }

    @Override
    public OriginsEnvironment reset() {
        super.reset();
        this.ringLights.reset();
        return this;
    }
}

