/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.origins;

import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.lights.ParticleCloudLight;
import com.beatcraft.render.particle.Particle;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_5819;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class OriginsParticleSpawner
implements ParticleCloudLight.CloudParticleSpawner {
    protected static final class_5819 random = class_5819.method_43047();

    @Override
    public Particle spawn(Vector3f position, Quaternionf orientation, Vector3f delta, float lifetime, LightState sharedLightState) {
        return new BarParticle(position, orientation, delta.mul((float)random.method_39332(-100, 100) / 100.0f, new Vector3f()), sharedLightState);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BarParticle
    implements Particle {
        private Vector3f position;
        private Quaternionf orientation;
        private Vector3f velocity;
        private Vector2f dimensions;
        private LightState sharedLightState;
        private double spawnTime;
        private List<Vector3f[]> tris;

        public BarParticle(Vector3f position, Quaternionf orientation, Vector3f velocity, LightState lightState) {
            this.velocity = velocity;
            this.position = position;
            this.orientation = orientation;
            this.sharedLightState = lightState;
            this.dimensions = new Vector2f((float)random.method_39332(1, 8) / 64.0f, (float)random.method_39332(2, 7) / 2.0f);
            this.spawnTime = (double)System.nanoTime() / 1.0E9;
            this.tris = BeatCraftRenderer.getGlowingQuadAsTris(this.dimensions, 0.025f);
        }

        @Override
        public void update(float deltaTime, class_287 buffer, Vector3f cameraPos) {
            if (HUDRenderer.scene != HUDRenderer.MenuScene.InGame) {
                return;
            }
            double t = (double)System.nanoTime() / 1.0E9;
            double dt = t - this.spawnTime;
            float a = 0.0f;
            if (dt <= 1.0) {
                a = (float)dt;
            } else if (dt <= 4.0) {
                a = 1.0f;
            } else if (dt <= 5.0) {
                a = 1.0f - ((float)dt - 4.0f);
            }
            int baseColor = this.sharedLightState.getEffectiveColor();
            int originalAlpha = baseColor >> 24 & 0xFF;
            int scaledAlpha = Math.round(a * (float)originalAlpha);
            int c = scaledAlpha << 24 | baseColor & 0xFFFFFF;
            int c2 = c & 0xFFFFFF | 0x1000000;
            for (Vector3f[] tri : this.tris) {
                Vector3f v0 = MemoryPool.newVector3f(tri[0].x, 0.0f, tri[0].y).rotate((Quaternionfc)this.orientation).add((Vector3fc)this.position).sub((Vector3fc)cameraPos);
                Vector3f v1 = MemoryPool.newVector3f(tri[1].x, 0.0f, tri[1].y).rotate((Quaternionfc)this.orientation).add((Vector3fc)this.position).sub((Vector3fc)cameraPos);
                Vector3f v2 = MemoryPool.newVector3f(tri[2].x, 0.0f, tri[2].y).rotate((Quaternionfc)this.orientation).add((Vector3fc)this.position).sub((Vector3fc)cameraPos);
                buffer.method_60830(v0).method_39415(tri[0].z < 0.5f ? c2 : c);
                buffer.method_60830(v1).method_39415(tri[1].z < 0.5f ? c2 : c);
                buffer.method_60830(v2).method_39415(tri[2].z < 0.5f ? c2 : c);
                MemoryPool.release(v0, v1, v2);
            }
            Vector3f v = this.velocity.mul(deltaTime, MemoryPool.newVector3f());
            this.position.add((Vector3fc)v);
            MemoryPool.release(v);
        }

        @Override
        public boolean shouldRemove() {
            double t = (double)System.nanoTime() / 1.0E9;
            double dt = t - this.spawnTime;
            return dt >= 5.0;
        }
    }
}

