/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.triangle;

import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.Bloomfog;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class InnerRing
extends LightObject {
    private static InnerRing INSTANCE;
    private static final float ringRadius = 11.0f;
    private static final float ringWidth = 1.0f;
    private static final float ringDepth = 0.1f;
    private static final int color = -16777216;
    private static final float rotationOffsetRad = 1.8325957f;
    private static final Vector3f[] dirs;
    private static Vector3f[] vertices;
    private static final Integer[] quads;

    private InnerRing() {
        this.orientation = new Quaternionf().rotationZ(0.7853982f);
    }

    public static InnerRing getInstance(BiFunction<Vector3f, Quaternionf, LightObject> ignored) {
        if (INSTANCE == null) {
            INSTANCE = new InnerRing();
        }
        return INSTANCE;
    }

    @Override
    public InnerRing cloneOffset(Vector3f offset) {
        return this;
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
        InnerRing.resetVertices();
        Vector3f pos = new Vector3f((Vector3fc)this.position);
        Vector3f off = new Vector3f((Vector3fc)this.offset);
        Quaternionf ori = new Quaternionf((Quaternionfc)this.orientation);
        Quaternionf rot = new Quaternionf((Quaternionfc)this.rotation);
        BeatCraftRenderer.recordBloomfogPosColCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render((class_287)b, (Vector3f)c, pos, off, ori, rot, bloomfog)));
    }

    private Vector3f processVertex(Vector3f base, Vector3f pos, Vector3f off, Quaternionf ori, Quaternionf rot, Vector3f camera) {
        return new Vector3f((Vector3fc)base).rotate((Quaternionfc)ori).add((Vector3fc)pos).rotate((Quaternionfc)rot).add((Vector3fc)off).sub((Vector3fc)camera);
    }

    private static Vector3f dir(float angleRad) {
        return new Vector3f((float)Math.cos(angleRad), (float)Math.sin(angleRad), 0.0f);
    }

    private static Vector3f offset(Vector3f dir, float dist, float z) {
        return new Vector3f(dir.x * dist, dir.y * dist, z).rotateZ(0.7853982f).add((Vector3fc)new Vector3f((float)(Math.cos(1.832595705986023) * 11.0), (float)(-(Math.sin(-0.2617993950843811) * 11.0)), 0.0f).rotateZ(-0.7853982f));
    }

    public static void resetVertices() {
        vertices = new Vector3f[]{InnerRing.offset(dirs[0], 12.0f, -0.1f), InnerRing.offset(dirs[1], 12.0f, -0.1f), InnerRing.offset(dirs[2], 12.0f, -0.1f), InnerRing.offset(dirs[0], 11.0f, 0.0f), InnerRing.offset(dirs[1], 11.0f, 0.0f), InnerRing.offset(dirs[2], 11.0f, 0.0f), InnerRing.offset(dirs[0], 11.0f, 0.1f), InnerRing.offset(dirs[1], 11.0f, 0.1f), InnerRing.offset(dirs[2], 11.0f, 0.1f)};
    }

    private void _render(class_287 buffer, Vector3f cameraPos, Vector3f position, Vector3f offset, Quaternionf orientation, Quaternionf rotation, Bloomfog bloomfog) {
        for (Integer vertex : quads) {
            buffer.method_60830(this.processVertex(vertices[vertex], position, offset, orientation, rotation, cameraPos)).method_39415(-16777216);
        }
    }

    @Override
    public void setBrightness(float value) {
    }

    @Override
    public void setColor(int color) {
    }

    static {
        dirs = new Vector3f[]{InnerRing.dir(1.8325957f), InnerRing.dir(3.926991f), InnerRing.dir(6.021386f)};
        vertices = new Vector3f[]{InnerRing.offset(dirs[0], 12.0f, -0.1f), InnerRing.offset(dirs[1], 12.0f, -0.1f), InnerRing.offset(dirs[2], 12.0f, -0.1f), InnerRing.offset(dirs[0], 11.0f, 0.0f), InnerRing.offset(dirs[1], 11.0f, 0.0f), InnerRing.offset(dirs[2], 11.0f, 0.0f), InnerRing.offset(dirs[0], 11.0f, 0.1f), InnerRing.offset(dirs[1], 11.0f, 0.1f), InnerRing.offset(dirs[2], 11.0f, 0.1f)};
        quads = new Integer[]{0, 1, 4, 3, 1, 2, 5, 4, 2, 0, 3, 5, 3, 4, 7, 6, 4, 5, 8, 7, 5, 3, 6, 8};
    }
}

