/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.environment.weave;

import com.beatcraft.lightshow.environment.EnvironmentV3;
import com.beatcraft.lightshow.environment.lightgroup.LightGroupV3;
import com.beatcraft.lightshow.environment.lightgroup.OrientableLightGroup;
import com.beatcraft.lightshow.event.events.LightEventV3;
import com.beatcraft.lightshow.event.events.RotationEventV3;
import com.beatcraft.lightshow.event.events.TranslationEvent;
import com.beatcraft.lightshow.event.handlers.GroupEventHandlerV3;
import com.beatcraft.lightshow.lights.CompoundTransformState;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.lights.TransformState;
import com.beatcraft.render.lights.FloodLight;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WeaveEnvironment
extends EnvironmentV3 {
    private static final float CENTER_Y = 1.75f;
    private static final float INNER_OFFSET_X = 3.5f;
    private static final float INNER_OFFSET_Y = 5.0f;
    private static final float[] INNER_SEGMENTS = new float[]{3.499f, 3.501f, 4.999f, 5.001f};
    private static final float OUTER_OFFSET_X = 6.0f;
    private static final float OUTER_OFFSET_Y = 3.75f;
    private static final float[] OUTER_SEGMENTS = new float[]{3.749f, 3.751f, 3.499f, 3.501f};
    private static final float SIDE_OFFSET_X = 7.0f;
    private static final float SIDE_OFFSET_Y = 1.875f;
    private static final float[] SIDE_SEGMENTS = new float[]{1.874f, 1.876f, 6.999f, 7.001f};
    private static final float OUTER_Z = 8.0f;
    private static final float INNER_Z = 8.875f;
    private static final float SIDE_Z = 9.75f;
    private static final float DISTANT_W = 5.5f;
    private static final float DISTANT_H = 3.75f;
    private static final float DISTANT_Z = 35.0f;
    private static final float INNER_LENGTH = 16.0f;
    private static final float OUTER_LENGTH = 16.0f;
    private static final float SIDE_LENGTH = 16.0f;
    private static final float DISTANT_LENGTH = 37.5f;
    private static final float INNER_FADE_LENGTH = 9.0f;
    private static final float OUTER_FADE_LENGTH = 9.0f;
    private static final float SIDE_FADE_LENGTH = 9.0f;
    private static final float DISTANT_FADE_LENGTH = 22.5f;
    private static final float INNER_SPREAD = 0.15f;
    private static final float OUTER_SPREAD = 0.15f;
    private static final float SIDE_SPREAD = 0.15f;
    private static final float DISTANT_SPREAD = 0.15f;
    private static final Vector3f LIGHT_GAP = new Vector3f(0.0f, 0.0f, 3.5f);
    private HashMap<Integer, class_3545<LightGroupV3, GroupEventHandlerV3>> eventGroups;

    @Override
    public HashMap<Integer, class_3545<LightGroupV3, GroupEventHandlerV3>> getEventGroups() {
        return this.eventGroups;
    }

    @Override
    public String getID() {
        return "WeaveEnvironment";
    }

    @Override
    public void setup() {
        this.eventGroups = new HashMap();
        this.setupOuterLights();
        this.setupInnerLights();
        this.setupSideLights();
        this.setupDistantLights();
    }

    private List<LightObject> stackLights(LightObject light, Vector3f step, int count) {
        ArrayList<LightObject> result = new ArrayList<LightObject>();
        result.add(light);
        for (int i = 0; i < count; ++i) {
            light = light.cloneOffset(step);
            result.add(light);
        }
        return result;
    }

    private void setupOuterLights() {
        int lightID = 0;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, OUTER_SEGMENTS, new Vector3f(6.0f, -2.0f, 8.0f), new Quaternionf()).withRotation(new Quaternionf()).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.PNP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup outerBL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 outerBLHandler = new GroupEventHandlerV3(outerBL);
        this.eventGroups.put(0, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)outerBL, (Object)outerBLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, OUTER_SEGMENTS, new Vector3f(-6.0f, -2.0f, 8.0f), new Quaternionf()).withRotation(new Quaternionf()).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NPN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup outerBR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 outerBRHandler = new GroupEventHandlerV3(outerBR);
        this.eventGroups.put(1, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)outerBR, (Object)outerBRHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, OUTER_SEGMENTS, new Vector3f(6.0f, 5.5f, 8.0f), new Quaternionf()).withRotation(new Quaternionf().rotationZ((float)Math.PI)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.PPN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup outerTL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 outerTLHandler = new GroupEventHandlerV3(outerTL);
        this.eventGroups.put(2, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)outerTL, (Object)outerTLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, OUTER_SEGMENTS, new Vector3f(-6.0f, 5.5f, 8.0f), new Quaternionf()).withRotation(new Quaternionf().rotationZ((float)Math.PI)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup outerTR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 outerTRHandler = new GroupEventHandlerV3(outerTR);
        this.eventGroups.put(3, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)outerTR, (Object)outerTRHandler));
    }

    private void setupInnerLights() {
        int lightID = 0;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, INNER_SEGMENTS, new Vector3f(3.5f, -3.25f, 8.875f), new Quaternionf()).withRotation(new Quaternionf()).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.PNP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup innerBL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 innerBLHandler = new GroupEventHandlerV3(innerBL);
        this.eventGroups.put(4, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)innerBL, (Object)innerBLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, INNER_SEGMENTS, new Vector3f(-3.5f, -3.25f, 8.875f), new Quaternionf()).withRotation(new Quaternionf()).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NPN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup innerBR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 innerBRHandler = new GroupEventHandlerV3(innerBR);
        this.eventGroups.put(5, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)innerBR, (Object)innerBRHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, INNER_SEGMENTS, new Vector3f(3.5f, 6.75f, 8.875f), new Quaternionf()).withRotation(new Quaternionf().rotationZ((float)Math.PI)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.PPN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup innerTL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 innerTLHandler = new GroupEventHandlerV3(innerTL);
        this.eventGroups.put(6, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)innerTL, (Object)innerTLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, INNER_SEGMENTS, new Vector3f(-3.5f, 6.75f, 8.875f), new Quaternionf()).withRotation(new Quaternionf().rotationZ((float)Math.PI)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup innerTR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 innerTRHandler = new GroupEventHandlerV3(innerTR);
        this.eventGroups.put(7, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)innerTR, (Object)innerTRHandler));
    }

    private void setupSideLights() {
        int lightID = 0;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, SIDE_SEGMENTS, new Vector3f(7.0f, -0.125f, 9.75f), new Quaternionf()).withRotation(new Quaternionf().rotationZ(1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NPP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup sideBL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 sideBLHandler = new GroupEventHandlerV3(sideBL);
        this.eventGroups.put(8, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)sideBL, (Object)sideBLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, SIDE_SEGMENTS, new Vector3f(-7.0f, -0.125f, 9.75f), new Quaternionf()).withRotation(new Quaternionf().rotationZ(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup sideBR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 sideBRHandler = new GroupEventHandlerV3(sideBR);
        this.eventGroups.put(9, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)sideBR, (Object)sideBRHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, SIDE_SEGMENTS, new Vector3f(7.0f, 3.625f, 9.75f), new Quaternionf()).withRotation(new Quaternionf().rotationZ(1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNN), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup sideTL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 sideTLHandler = new GroupEventHandlerV3(sideTL);
        this.eventGroups.put(10, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)sideTL, (Object)sideTLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 16.0f, 9.0f, 0.15f, SIDE_SEGMENTS, new Vector3f(-7.0f, 3.625f, 9.75f), new Quaternionf()).withRotation(new Quaternionf().rotationZ(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NPP), LIGHT_GAP, 7)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup sideTR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 sideTRHandler = new GroupEventHandlerV3(sideTR);
        this.eventGroups.put(11, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)sideTR, (Object)sideTRHandler));
    }

    private void setupDistantLights() {
        int lightID = 0;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 37.5f, 22.5f, 0.15f, new float[0], new Vector3f(5.5f, 6.3333335f, 35.0f), new Quaternionf()).withRotation(new Quaternionf().rotationX(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.XYZ, CompoundTransformState.Polarity.NNP), new Vector3f(-1.0f, 0.0f, 0.0f), 11)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup distantT = new OrientableLightGroup(lights);
        GroupEventHandlerV3 distantTHandler = new GroupEventHandlerV3(distantT);
        this.eventGroups.put(12, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)distantT, (Object)distantTHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 37.5f, 22.5f, 0.15f, new float[0], new Vector3f(-5.5f, -2.8333333f, 35.0f), new Quaternionf()).withRotation(new Quaternionf().rotationX(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.XYZ, CompoundTransformState.Polarity.PNP), new Vector3f(1.0f, 0.0f, 0.0f), 11)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup distantD = new OrientableLightGroup(lights);
        GroupEventHandlerV3 distantDHandler = new GroupEventHandlerV3(distantD);
        this.eventGroups.put(13, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)distantD, (Object)distantDHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 37.5f, 22.5f, 0.15f, new float[0], new Vector3f(6.5f, -2.0f, 35.0f), new Quaternionf().rotateY(1.5707964f)).withRotation(new Quaternionf().rotateX(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNP), new Vector3f(0.0f, 0.8333333f, 0.0f), 9)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup distantL = new OrientableLightGroup(lights);
        GroupEventHandlerV3 distantLHandler = new GroupEventHandlerV3(distantL);
        this.eventGroups.put(14, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)distantL, (Object)distantLHandler));
        lightID = 0;
        lights = new HashMap();
        for (LightObject light : this.stackLights(new FloodLight(0.125f, 0.075f, 37.5f, 22.5f, 0.15f, new float[0], new Vector3f(-6.5f, 5.5f, 35.0f), new Quaternionf().rotateY(-1.5707964f)).withRotation(new Quaternionf().rotateX(-1.5707964f)).withRotationSwizzle(CompoundTransformState.Swizzle.ZYX, CompoundTransformState.Polarity.NNN), new Vector3f(0.0f, -0.8333333f, 0.0f), 9)) {
            lights.put(lightID++, light);
        }
        OrientableLightGroup distantR = new OrientableLightGroup(lights);
        GroupEventHandlerV3 distantRHandler = new GroupEventHandlerV3(distantR);
        this.eventGroups.put(15, (class_3545<LightGroupV3, GroupEventHandlerV3>)new class_3545((Object)distantR, (Object)distantRHandler));
    }

    @Override
    public WeaveEnvironment reset() {
        super.reset();
        this.eventGroups.forEach((k, v) -> {
            ((GroupEventHandlerV3)v.method_15441()).reset();
            ((GroupEventHandlerV3)v.method_15441()).clear();
            ((LightGroupV3)v.method_15442()).reset();
        });
        return this;
    }

    @Override
    public int getGroupCount() {
        return 16;
    }

    @Override
    public int getLightCount(int group) {
        if (group < 12) {
            return 8;
        }
        if (group < 14) {
            return 12;
        }
        return 10;
    }

    @Override
    protected void linkEvents(int group, int lightID, List<LightEventV3> lightEvents, HashMap<TransformState.Axis, ArrayList<RotationEventV3>> rotationEvents, HashMap<TransformState.Axis, ArrayList<TranslationEvent>> ignored, List<Integer> ignored0) {
        if (this.eventGroups.containsKey(group)) {
            ((GroupEventHandlerV3)this.eventGroups.get(group).method_15441()).linkLightEvents(lightEvents);
            ((GroupEventHandlerV3)this.eventGroups.get(group).method_15441()).linkRotationEvents(lightID, rotationEvents);
        }
    }

    @Override
    public void update(float beat, double deltaTime) {
        super.update(beat, deltaTime);
        this.eventGroups.forEach((k, v) -> ((GroupEventHandlerV3)v.method_15441()).update(beat));
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera) {
        super.render(matrices, camera);
        this.eventGroups.forEach((k, v) -> ((LightGroupV3)v.method_15442()).render(matrices, camera));
    }
}

