/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event;

import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

@Environment(value=EnvType.CLIENT)
public class Filter
implements Iterable<Triplet<Integer[], Float, Float>> {
    protected final int start;
    protected final int step;
    protected final int count;
    protected final int lightCount;
    protected final int randomBehavior;
    protected final int randomSeed;
    protected final int chunkSize;
    protected final int limitBehavior;
    protected final int visibleCount;
    protected final int chunkCount;
    protected final float limitPercentage;
    private ArrayList<Triplet<Integer[], Float, Float>> targets;

    public static Filter processFilter(int lightCount, ArrayList<Integer> coveredIds, JsonObject filter) {
        int count;
        Integer chunks = JsonUtil.getOrDefault(filter, "c", JsonElement::getAsInt, Integer.valueOf(0));
        Integer type = JsonUtil.getOrDefault(filter, "f", JsonElement::getAsInt, Integer.valueOf(0));
        Integer p0 = JsonUtil.getOrDefault(filter, "p", JsonElement::getAsInt, Integer.valueOf(0));
        Integer p1 = JsonUtil.getOrDefault(filter, "t", JsonElement::getAsInt, Integer.valueOf(0));
        boolean reverse = JsonUtil.getOrDefault(filter, "r", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
        Integer randomBehavior = JsonUtil.getOrDefault(filter, "n", JsonElement::getAsInt, Integer.valueOf(0));
        Integer randomSeed = JsonUtil.getOrDefault(filter, "s", JsonElement::getAsInt, Integer.valueOf(0));
        Float limitPercent = JsonUtil.getOrDefault(filter, "l", JsonElement::getAsFloat, Float.valueOf(0.0f));
        Integer limitBehavior = JsonUtil.getOrDefault(filter, "d", JsonElement::getAsInt, Integer.valueOf(0));
        if (chunks == 0) {
            chunks = lightCount;
        }
        int chunkSize = (int)Math.ceil((float)lightCount / (float)chunks.intValue());
        int chunkCount = (int)Math.ceil((float)lightCount / (float)chunkSize);
        if (type == 1) {
            int sector = (int)Math.ceil((float)chunkCount / (float)p0.intValue());
            if (reverse) {
                int start = chunkCount - sector * p1 - 1;
                return new Filter(start, Math.max(0, start - sector + 1), lightCount, randomBehavior, randomSeed, chunkSize, limitBehavior, limitPercent.floatValue(), coveredIds);
            }
            int sector2 = sector * p1;
            return new Filter(sector2, Math.min(chunkCount - 1, sector2 + sector - 1), lightCount, randomBehavior, randomSeed, chunkSize, limitBehavior, limitPercent.floatValue(), coveredIds);
        }
        float size = chunkCount - p0;
        int n = count = p1 == 0 ? 1 : (int)Math.ceil(size / (float)p1.intValue());
        if (reverse) {
            return new Filter(chunkCount - 1 - p0, -p1.intValue(), count, lightCount, randomBehavior, randomSeed, chunkSize, limitBehavior, limitPercent.floatValue(), coveredIds);
        }
        return new Filter(p0, p1, count, lightCount, randomBehavior, randomSeed, chunkSize, limitBehavior, limitPercent.floatValue(), coveredIds);
    }

    private void randomize(ArrayList<Integer> values, int seed) {
        Random random = new Random(seed);
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (Integer i : values) {
            int insertionIndex = random.nextInt(out.size() + 1);
            if (insertionIndex == out.size()) {
                out.add(i);
                continue;
            }
            out.add((Integer)out.get(insertionIndex));
            out.set(insertionIndex, i);
        }
        values.clear();
        values.addAll(out);
    }

    private void reOrder(ArrayList<Integer> ordering, boolean randomize, int limit, int count, int seed) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        int index = 0;
        if (randomize) {
            Random random = new Random(seed);
            int picked = 0;
            for (Integer o : ordering) {
                if (random.nextInt(count - index) > limit - picked) {
                    ++picked;
                    out.add(o);
                } else {
                    out.add(-1);
                }
                ++index;
            }
        } else {
            for (Integer o : ordering) {
                if (index < limit) {
                    out.add(o);
                } else {
                    out.add(-1);
                }
                ++index;
            }
        }
        ordering.clear();
        ordering.addAll(out);
    }

    private ArrayList<class_3545<Integer, Integer>> zip(ArrayList<Integer> left, ArrayList<Integer> right) {
        int count = Math.min(left.size(), right.size());
        ArrayList<class_3545<Integer, Integer>> out = new ArrayList<class_3545<Integer, Integer>>();
        for (int i = 0; i < count; ++i) {
            Integer r = right.get(i);
            if (r == -1) continue;
            out.add((class_3545<Integer, Integer>)new class_3545((Object)left.get(i), (Object)r));
        }
        return out;
    }

    public Filter(int start, int end, int lightCount, int randomBehavior, int randomSeed, int chunkSize, int limitBehavior, float limitPercent, ArrayList<Integer> coveredIds) {
        this(start, end - start >= 0 ? 1 : -1, Math.abs(end - start) + 1, lightCount, randomBehavior, randomSeed, chunkSize, limitBehavior, limitPercent, coveredIds);
    }

    public Filter(int start, int step, int count, int lightCount, int randomBehavior, int randomSeed, int chunkSize, int limitBehavior, float limitPercentage, ArrayList<Integer> coveredIds) {
        this.start = start;
        this.step = step;
        this.count = count;
        this.lightCount = lightCount;
        this.randomBehavior = randomBehavior;
        this.randomSeed = randomSeed;
        this.chunkSize = chunkSize;
        this.limitBehavior = limitBehavior;
        this.limitPercentage = limitPercentage == 0.0f ? 1.0f : limitPercentage;
        this.visibleCount = this.limitPercentage == 1.0f ? count : (int)Math.ceil(limitPercentage * (float)count);
        ArrayList<Integer> values = new ArrayList<Integer>();
        int value = start;
        for (int i = 0; i < lightCount; ++i) {
            values.add(value);
            value += step;
        }
        if (randomBehavior != 0 && (randomBehavior & 1) == 0) {
            this.randomize(values, randomSeed);
        }
        ArrayList<Integer> ordering = new ArrayList<Integer>();
        for (int o = 0; o < count; ++o) {
            ordering.add(o);
        }
        if (this.visibleCount > 0) {
            this.reOrder(ordering, (randomBehavior & 2) > 0, this.visibleCount, count, randomSeed);
        }
        ArrayList<class_3545<Integer, Integer>> orderedIds = this.zip(values, ordering);
        int limitedIndex = 0;
        int maxDurationIndex = 1;
        int maxDistributionIndex = 1;
        boolean limitDuration = (limitBehavior & 1) > 0;
        boolean limitDistribution = (limitBehavior & 2) > 0;
        this.targets = new ArrayList();
        for (class_3545<Integer, Integer> pair : orderedIds) {
            int n;
            Integer id = (Integer)pair.method_15442();
            Integer index = (Integer)pair.method_15441();
            int durationMod = limitDuration ? limitedIndex : index;
            int distributionMod = limitDistribution ? limitedIndex : index;
            maxDurationIndex = Math.max(maxDurationIndex, durationMod);
            maxDistributionIndex = Math.max(maxDistributionIndex, distributionMod);
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int localIdx = 0; localIdx < chunkSize && (n = id * chunkSize + localIdx) < lightCount; ++localIdx) {
                indices.add(n);
            }
            coveredIds.addAll(indices);
            this.targets.add((Triplet<Integer[], Float, Float>)new Triplet((Object)indices.toArray(new Integer[0]), (Object)Float.valueOf(durationMod), (Object)Float.valueOf(distributionMod)));
            ++limitedIndex;
        }
        this.chunkCount = this.targets.size();
        for (int i = 0; i < this.targets.size(); ++i) {
            Triplet<Integer[], Float, Float> t = this.targets.get(i);
            this.targets.set(i, (Triplet<Integer[], Float, Float>)new Triplet((Object)((Integer[])t.getA()), (Object)Float.valueOf(((Float)t.getB()).floatValue() / (float)maxDurationIndex), (Object)Float.valueOf(((Float)t.getC()).floatValue() / (float)maxDistributionIndex)));
        }
    }

    public int chunkCount() {
        return this.chunkCount;
    }

    @Override
    @NotNull
    public Iterator<Triplet<Integer[], Float, Float>> iterator() {
        return new FilterIterator(this);
    }

    @Environment(value=EnvType.CLIENT)
    public static class FilterIterator
    implements Iterator<Triplet<Integer[], Float, Float>> {
        private final Filter filter;
        private int index = 0;

        public FilterIterator(Filter filter) {
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.filter.targets.size();
        }

        @Override
        public Triplet<Integer[], Float, Float> next() {
            return this.filter.targets.get(this.index++);
        }
    }
}

