/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.events;

import com.beatcraft.animation.Easing;
import com.beatcraft.event.IEvent;
import com.beatcraft.lightshow.event.events.LightEvent;
import com.beatcraft.lightshow.lights.LightState;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LightEventV3
extends LightEvent
implements IEvent {
    public LightState lightState;
    public int lightID;
    public LightState startState;
    public float duration;
    public Function<Float, Float> easing;

    public LightEventV3(float beat, LightState startState, LightState endState, float duration, int lightID, Function<Float, Float> easing) {
        this.beat = beat;
        this.startState = startState;
        this.lightID = lightID;
        this.lightState = endState;
        this.duration = duration;
        this.easing = easing;
    }

    @Override
    public boolean containsLightID(int lightID) {
        return this.lightID == lightID;
    }

    @Override
    public float getEventBeat() {
        return this.beat;
    }

    @Override
    public float getEventDuration() {
        return this.duration;
    }

    public LightEventV3 extendTo(float beat) {
        return new LightEventV3(this.beat + this.duration, this.lightState, this.lightState, beat - (this.beat + this.duration), this.lightID, Easing::easeLinear);
    }

    public String toString() {
        return "LightEventV3{beat=" + this.beat + ", lightState=" + String.valueOf(this.lightState) + ", lightID=" + this.lightID + ", startState=" + String.valueOf(this.startState) + ", duration=" + this.duration + "}";
    }
}

