/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.events;

import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.event.IEvent;
import com.beatcraft.lightshow.lights.TransformState;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RotationEventV3
extends BeatmapObject
implements IEvent {
    public TransformState transformState;
    public int lightID;
    public TransformState startState;
    public float duration;
    public Function<Float, Float> easing;
    public int loops;
    public int direction;

    public RotationEventV3(float beat, TransformState startState, TransformState endState, float duration, int lightID, Function<Float, Float> easing, int loops, int direction) {
        this.beat = beat;
        this.startState = startState;
        this.transformState = endState;
        this.duration = duration;
        this.lightID = lightID;
        this.easing = easing;
        this.loops = loops;
        this.direction = direction;
    }

    public RotationEventV3 extendTo(float beat) {
        return new RotationEventV3(this.beat + this.duration, this.transformState, this.transformState, beat - (this.beat + this.duration), this.lightID, this.easing, 0, 0);
    }

    @Override
    public float getEventBeat() {
        return this.beat;
    }

    @Override
    public float getEventDuration() {
        return this.duration;
    }

    public String toString() {
        return "TransformEvent{beat=" + this.beat + ", easing=" + String.valueOf(this.easing) + ", duration=" + this.duration + ", startState=" + String.valueOf(this.startState) + ", lightID=" + this.lightID + ", transformState=" + String.valueOf(this.transformState) + "}";
    }
}

