/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.handlers;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.data.types.Color;
import com.beatcraft.event.EventHandler;
import com.beatcraft.lightshow.event.events.LightEventV3;
import com.beatcraft.lightshow.lights.LightState;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class LightEventHandlerV3
extends EventHandler<LightState, LightEventV3> {
    public LightEventHandlerV3(List<LightEventV3> events) {
        super(events, new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f));
    }

    public void addEvents(List<LightEventV3> events) {
        this.events.addAll(events);
        this.events.sort(Difficulty::compareObjects);
        this.reset();
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public void onEventInterrupted(LightEventV3 event, float normalTime) {
    }

    private float calcOscillation(float startBeat, float currentBeat, float frequency, boolean fade) {
        float beatsSinceStart = currentBeat - startBeat;
        float totalCycles = beatsSinceStart * frequency;
        float cyclePosition = totalCycles % 1.0f;
        if (fade) {
            if (cyclePosition < 0.5f) {
                return cyclePosition * 2.0f;
            }
            return 2.0f * (1.0f - cyclePosition);
        }
        return cyclePosition >= 0.5f ? 1.0f : 0.0f;
    }

    @Override
    public void onInsideEvent(LightEventV3 event, float normalTime) {
        float currentBeat = class_3532.method_16439((float)normalTime, (float)event.getEventBeat(), (float)(event.getEventBeat() + event.getEventDuration()));
        float easedTime = event.easing.apply(Float.valueOf(normalTime)).floatValue();
        event.startState.lerpFromTo(event.lightState, easedTime, (LightState)this.state);
        float currentFrequency = class_3532.method_16439((float)easedTime, (float)event.startState.strobeFrequency, (float)event.lightState.strobeFrequency);
        float brightnessMod = currentFrequency == 0.0f ? 1.0f : this.calcOscillation(event.getEventBeat(), currentBeat, currentFrequency, event.startState.strobeFade);
        float low = class_3532.method_16439((float)easedTime, (float)event.startState.strobeBrightness, (float)event.lightState.strobeBrightness);
        float currentBrightness = class_3532.method_16439((float)brightnessMod, (float)low, (float)((LightState)this.state).getBrightness());
        ((LightState)this.state).setBrightness(currentBrightness);
    }

    @Override
    public void onEventPassed(LightEventV3 event) {
        ((LightState)this.state).set(event.lightState);
    }
}

