/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.handlers;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.event.EventHandler;
import com.beatcraft.lightshow.event.events.TranslationEvent;
import com.beatcraft.lightshow.lights.TransformState;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class TranslationEventHandler
extends EventHandler<TransformState, TranslationEvent> {
    public TranslationEventHandler(List<TranslationEvent> events, TransformState.Axis initialAxis) {
        super(events, new TransformState(initialAxis, 0.0f));
    }

    public void addEvents(List<TranslationEvent> events) {
        this.events.addAll(events);
        this.events.sort(Difficulty::compareObjects);
    }

    @Override
    public void onEventInterrupted(TranslationEvent event, float normalTime) {
    }

    @Override
    public void onInsideEvent(TranslationEvent event, float normalTime) {
        TransformState start = event.startState;
        TransformState end = event.transformState;
        Function<Float, Float> easing = event.easing;
        float easedTime = easing.apply(Float.valueOf(normalTime)).floatValue();
        float interpolatedPosition = class_3532.method_16439((float)easedTime, (float)start.value, (float)end.value);
        ((TransformState)this.state).set(start.axis, interpolatedPosition);
    }

    @Override
    public void onEventPassed(TranslationEvent event) {
        ((TransformState)this.state).set(event.transformState);
    }
}

