/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.lights;

import com.beatcraft.debug.BeatCraftDebug;
import com.beatcraft.lightshow.lights.TransformState;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CompoundTransformState {
    private float tx = 0.0f;
    private float ty = 0.0f;
    private float tz = 0.0f;
    private float rx = 0.0f;
    private float ry = 0.0f;
    private float rz = 0.0f;

    public void updateState(TransformState state) {
        switch (state.axis) {
            case TX: {
                this.tx = state.value;
                break;
            }
            case TY: {
                this.ty = state.value;
                break;
            }
            case TZ: {
                this.tz = state.value;
                break;
            }
            case RX: {
                this.rx = state.value;
                break;
            }
            case RY: {
                this.ry = state.value;
                break;
            }
            case RZ: {
                this.rz = state.value;
            }
        }
    }

    public void reset() {
        this.tx = 0.0f;
        this.ty = 0.0f;
        this.tz = 0.0f;
        this.rx = 0.0f;
        this.ry = 0.0f;
        this.rz = 0.0f;
    }

    public static float[] applySwizzle(float[] xyz, Swizzle swizzle) {
        float[] fArray;
        switch (swizzle.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                fArray = xyz;
                break;
            }
            case 1: {
                float[] fArray2 = new float[3];
                fArray2[0] = xyz[0];
                fArray2[1] = xyz[2];
                fArray = fArray2;
                fArray2[2] = xyz[1];
                break;
            }
            case 2: {
                float[] fArray3 = new float[3];
                fArray3[0] = xyz[1];
                fArray3[1] = xyz[0];
                fArray = fArray3;
                fArray3[2] = xyz[2];
                break;
            }
            case 3: {
                float[] fArray4 = new float[3];
                fArray4[0] = xyz[1];
                fArray4[1] = xyz[2];
                fArray = fArray4;
                fArray4[2] = xyz[0];
                break;
            }
            case 4: {
                float[] fArray5 = new float[3];
                fArray5[0] = xyz[2];
                fArray5[1] = xyz[0];
                fArray = fArray5;
                fArray5[2] = xyz[1];
                break;
            }
            case 5: {
                float[] fArray6 = new float[3];
                fArray6[0] = xyz[2];
                fArray6[1] = xyz[1];
                fArray = fArray6;
                fArray6[2] = xyz[0];
                break;
            }
            case 6: {
                fArray = swizzle.remap.apply(xyz);
            }
        }
        return fArray;
    }

    public static float[] applyPolarity(float[] xyz, Polarity polarity) {
        float[] fArray;
        switch (polarity.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                fArray = xyz;
                break;
            }
            case 1: {
                float[] fArray2 = new float[3];
                fArray2[0] = xyz[0];
                fArray2[1] = xyz[1];
                fArray = fArray2;
                fArray2[2] = -xyz[2];
                break;
            }
            case 2: {
                float[] fArray3 = new float[3];
                fArray3[0] = xyz[0];
                fArray3[1] = -xyz[1];
                fArray = fArray3;
                fArray3[2] = xyz[2];
                break;
            }
            case 3: {
                float[] fArray4 = new float[3];
                fArray4[0] = xyz[0];
                fArray4[1] = -xyz[1];
                fArray = fArray4;
                fArray4[2] = -xyz[2];
                break;
            }
            case 4: {
                float[] fArray5 = new float[3];
                fArray5[0] = -xyz[0];
                fArray5[1] = xyz[1];
                fArray = fArray5;
                fArray5[2] = xyz[2];
                break;
            }
            case 5: {
                float[] fArray6 = new float[3];
                fArray6[0] = -xyz[0];
                fArray6[1] = xyz[1];
                fArray = fArray6;
                fArray6[2] = -xyz[2];
                break;
            }
            case 6: {
                float[] fArray7 = new float[3];
                fArray7[0] = -xyz[0];
                fArray7[1] = -xyz[1];
                fArray = fArray7;
                fArray7[2] = xyz[2];
                break;
            }
            case 7: {
                float[] fArray8 = new float[3];
                fArray8[0] = -xyz[0];
                fArray8[1] = -xyz[1];
                fArray = fArray8;
                fArray8[2] = -xyz[2];
                break;
            }
            case 8: {
                fArray = polarity.remap.apply(xyz);
            }
        }
        return fArray;
    }

    public Vector3f getTranslation(Swizzle axisSwizzle, Polarity polarity) {
        float[] xyz = CompoundTransformState.applyPolarity(CompoundTransformState.applySwizzle(new float[]{this.tx, this.ty, this.tz}, axisSwizzle), polarity);
        return new Vector3f(xyz);
    }

    public Quaternionf getOrientation(Swizzle axisSwizzle, Polarity polarity, TriFunction<Float, Float, Float, Quaternionf> quaternionBuilder) {
        float[] xyz = CompoundTransformState.applyPolarity(CompoundTransformState.applySwizzle(new float[]{this.rx, this.ry, this.rz}, axisSwizzle), polarity);
        float dx = xyz[0] * ((float)Math.PI / 180);
        float dy = xyz[1] * ((float)Math.PI / 180);
        float dz = xyz[2] * ((float)Math.PI / 180);
        return (Quaternionf)quaternionBuilder.apply((Object)Float.valueOf(dx), (Object)Float.valueOf(dy), (Object)Float.valueOf(dz));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Swizzle {
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX,
        Dynamic;

        private Function<float[], float[]> remap;

        public static Swizzle getDynamic(String key) {
            return Swizzle.getDynamic((float[] xyz) -> {
                int sw = (Integer)BeatCraftDebug.getValue(key, 0);
                Swizzle swizzle = Swizzle.values()[Math.clamp((long)sw, 0, 5)];
                return CompoundTransformState.applySwizzle(xyz, swizzle);
            });
        }

        public static Swizzle getDynamic(Function<float[], float[]> remap) {
            Swizzle sw = Dynamic;
            sw.remap = remap;
            return sw;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Polarity {
        PPP,
        PPN,
        PNP,
        PNN,
        NPP,
        NPN,
        NNP,
        NNN,
        Dynamic;

        private Function<float[], float[]> remap;

        public static Polarity getDynamic(String key) {
            return Polarity.getDynamic((float[] xyz) -> {
                int po = (Integer)BeatCraftDebug.getValue(key, 0);
                Polarity polarity = Polarity.values()[Math.clamp((long)po, 0, 7)];
                return CompoundTransformState.applyPolarity(xyz, polarity);
            });
        }

        public static Polarity getDynamic(Function<float[], float[]> remap) {
            Polarity po = Dynamic;
            po.remap = remap;
            return po;
        }
    }
}

