/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.lights;

import com.beatcraft.data.types.Color;
import com.beatcraft.utils.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class LightState {
    private Color color;
    private float brightness;
    private int effectiveColor = 0;
    public float strobeBrightness = 0.0f;
    public float strobeFrequency = 0.0f;
    public boolean strobeFade = false;

    public void setStrobeState(float brightness, float frequency, boolean fade) {
        this.strobeBrightness = brightness;
        this.strobeFrequency = frequency;
        this.strobeFade = fade;
    }

    public LightState(Color color, float brightness) {
        this.color = color;
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public void reset() {
        this.color.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.brightness = 0.0f;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public LightState lerpFromTo(LightState to, float t) {
        Color c = MathUtil.lerpColor(this.color, to.color, t);
        float b = class_3532.method_16439((float)t, (float)this.brightness, (float)to.brightness);
        return new LightState(c, b);
    }

    public void lerpFromTo(LightState to, float t, LightState dest) {
        Color c = MathUtil.lerpColor(this.color, to.color, t);
        float b = class_3532.method_16439((float)t, (float)this.brightness, (float)to.brightness);
        dest.set(c, b);
    }

    public void set(LightState other) {
        this.color.set(other.color);
        this.brightness = other.brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public LightState lerpToFrom(LightState from, float t) {
        return from.lerpFromTo(this, t);
    }

    public LightState copy() {
        LightState ls = new LightState(this.color.copy(), this.brightness);
        ls.setStrobeState(this.strobeBrightness, this.strobeFrequency, this.strobeFade);
        return ls;
    }

    private int calcEffectiveColor() {
        return this.color.lerpBrightness(this.brightness * 1.2f);
    }

    public int getEffectiveColor() {
        return this.effectiveColor;
    }

    public int getBloomColor() {
        return this.color.lerpBrightness(this.brightness);
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int getColor() {
        return this.color.toARGB();
    }

    public void clampAlpha() {
        this.color.setAlpha(Math.max(0.003921569f, this.color.getAlpha()));
    }

    public void setColor(Color color) {
        this.color = color;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    private void set(Color color, float brightness) {
        this.color = color;
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public String toString() {
        return String.format("LightState{c:%s, b:%s}", Long.toString(this.getColor(), 16), Float.valueOf(this.brightness));
    }
}

