/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.ring_lights;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.Easing;
import com.beatcraft.data.types.Color;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.render.effect.Bloomfog;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class RingLightHandler
extends LightObject {
    class_5819 random = class_5819.method_43047();
    private int ringCount;
    private float ringOffset;
    private float zoom = 1.0f;
    private float ringRotation = 0.0f;
    private float rotationStep = 0.0f;
    public float[] jumpOffsets = new float[0];
    public float[] rotationOffsets = new float[0];
    private float currentOffset = 0.0f;
    private final RingHandler headRing;

    public RingLightHandler(Function<BiFunction<Vector3f, Quaternionf, LightObject>, LightObject> ringFactory, BiFunction<Vector3f, Quaternionf, LightObject> lightBuilder, int count, Vector3f position, float ringGap) {
        this.ringCount = count;
        this.position = position;
        this.ringOffset = ringGap;
        RingHandler last = this.headRing = new RingHandler(this, 0, ringFactory.apply(lightBuilder));
        for (int i = 1; i < this.ringCount; ++i) {
            RingHandler current;
            last.nextRing = current = new RingHandler(this, i, ringFactory.apply(lightBuilder));
            last = current;
        }
    }

    public void reset() {
        this.ringRotation = 0.0f;
        this.rotationStep = 0.0f;
        this.currentOffset = 0.0f;
        this.zoom = 1.0f;
        this.headRing.reset();
    }

    public void update(float songTime) {
        this.headRing.update(songTime);
    }

    @Override
    public RingLightHandler cloneOffset(Vector3f offset) {
        return this;
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
        this.headRing.render(matrices, camera, bloomfog);
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }

    public void spinRandom() {
        int i;
        float offset = this.currentOffset;
        while (offset == this.currentOffset && this.rotationOffsets.length > 1) {
            i = this.random.method_39332(0, this.rotationOffsets.length - 1);
            offset = this.rotationOffsets[i];
        }
        this.rotationStep = offset;
        i = this.random.method_39332(0, this.jumpOffsets.length - 1);
        this.ringRotation += this.jumpOffsets[i];
        this.headRing.setTarget(BeatmapPlayer.getCurrentSeconds(), this.ringRotation, this.rotationStep);
    }

    public void setZoom(float value) {
        this.headRing.setZoomStart(BeatmapPlayer.getCurrentSeconds());
        this.zoom = value;
    }

    public float getZoom() {
        return this.zoom;
    }

    @Environment(value=EnvType.CLIENT)
    protected static class RingHandler {
        private RingLightHandler controller;
        private float rotation = 0.0f;
        private Float startTime = null;
        private Float zoomStart = null;
        private float startRotation = 0.0f;
        private float targetRotation = 0.0f;
        private RingHandler nextRing = null;
        private float prevZoom = 1.0f;
        private final int index;
        private LightObject ringLight;
        private float cachedRingRotation = 0.0f;
        private float cachedRotationStep = 0.0f;
        private boolean setNext = false;

        protected RingHandler(RingLightHandler controller, int index, LightObject ringLight) {
            this.ringLight = ringLight;
            this.controller = controller;
            this.index = index;
        }

        protected void setTarget(float songTime, float ringRotation, float rotationStep) {
            this.startRotation = this.rotation;
            this.cachedRingRotation = ringRotation;
            this.cachedRotationStep = rotationStep;
            this.targetRotation = ringRotation + rotationStep * (float)this.index;
            this.startTime = Float.valueOf(songTime);
            this.setNext = true;
        }

        protected void setZoomStart(float songTime) {
            this.prevZoom = this.controller.zoom;
            this.zoomStart = Float.valueOf(songTime);
            if (this.nextRing != null) {
                this.nextRing.setZoomStart(songTime);
            }
        }

        private float lerpZoom(float songTime) {
            if (this.zoomStart == null) {
                return this.prevZoom;
            }
            float dt = songTime - this.zoomStart.floatValue();
            if (dt >= 1.0f) {
                this.prevZoom = this.controller.zoom;
                this.zoomStart = null;
            }
            return class_3532.method_16439((float)Easing.easeOutExpo(dt), (float)this.prevZoom, (float)this.controller.zoom);
        }

        protected void reset() {
            this.rotation = 0.0f;
            this.startTime = null;
            this.zoomStart = null;
            this.startRotation = 0.0f;
            this.targetRotation = 0.0f;
            this.prevZoom = 1.0f;
            if (this.nextRing != null) {
                this.nextRing.reset();
            }
        }

        protected void update(float songTime) {
            if (this.startTime != null) {
                float dt = songTime - this.startTime.floatValue();
                this.rotation = class_3532.method_16439((float)Easing.easeOutExpo(dt), (float)this.startRotation, (float)this.targetRotation);
                if (this.nextRing != null && dt > 0.01f && this.setNext) {
                    this.nextRing.setTarget(songTime, this.cachedRingRotation + this.cachedRotationStep, this.cachedRotationStep);
                    this.setNext = false;
                }
                if (dt >= 1.0f) {
                    this.rotation = this.targetRotation;
                    this.startTime = null;
                }
            }
            if (this.nextRing != null) {
                this.nextRing.update(songTime);
            }
        }

        protected void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
            if (this.ringLight == null) {
                return;
            }
            this.ringLight.setOffset(new Vector3f(0.0f, 0.0f, this.controller.ringOffset * this.lerpZoom(BeatmapPlayer.getCurrentSeconds()) * (float)this.index).rotate((Quaternionfc)this.controller.orientation).rotate((Quaternionfc)this.controller.rotation).add((Vector3fc)this.controller.position).add((Vector3fc)this.controller.offset));
            this.ringLight.setRotation(new Quaternionf().rotationZ(this.rotation).mul((Quaternionfc)this.controller.orientation).mul((Quaternionfc)this.controller.rotation));
            this.ringLight.render(matrices, camera, bloomfog);
            if (this.nextRing != null) {
                this.nextRing.render(matrices, camera, bloomfog);
            }
        }
    }
}

