/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.spectrogram;

import com.beatcraft.animation.Easing;
import com.beatcraft.audio.SpectrogramAnalyzer;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class SpectrogramTowers {
    private SpectrogramAnalyzer spectrogram;
    private Vector3f position;
    private Quaternionf orientation;
    private Vector3f towerOffset;
    private int towerCount;
    private TowerStyle towerStyle;
    public float levelModifier = 1.0f;
    public Function<Float, Float> levelEasing = Easing::easeLinear;
    private boolean splitHalfway;
    public float baseHeight = 0.0f;
    public float maxHeight = 9.0f;
    private float[] decayHeights;
    private Vector3f upVec = new Vector3f();

    public SpectrogramTowers(Vector3f position, Quaternionf orientation, Vector3f towerOffset, int towerCount, File soundFile, TowerStyle towerStyle, boolean splitHalfway) {
        this.position = position;
        this.orientation = orientation;
        this.towerOffset = towerOffset;
        this.towerCount = towerCount;
        this.towerStyle = towerStyle;
        this.splitHalfway = splitHalfway;
        int count = splitHalfway ? (int)Math.ceil((float)towerCount / 2.0f) : towerCount;
        this.decayHeights = new float[count];
        this.spectrogram = new SpectrogramAnalyzer(soundFile, count);
    }

    private SpectrogramTowers(Vector3f position, Quaternionf orientation, Vector3f towerOffset, int towerCount, TowerStyle towerStyle, boolean splitHalfway) {
        this.position = position;
        this.orientation = orientation;
        this.towerOffset = towerOffset;
        this.towerCount = towerCount;
        this.towerStyle = towerStyle;
        this.splitHalfway = splitHalfway;
        int count = splitHalfway ? (int)Math.ceil((float)towerCount / 2.0f) : towerCount;
        this.decayHeights = new float[count];
    }

    public SpectrogramTowers copyTo(Vector3f position, Quaternionf orientation) {
        SpectrogramTowers other = new SpectrogramTowers(position, orientation, this.towerOffset, this.towerCount, this.towerStyle, this.splitHalfway);
        other.spectrogram = this.spectrogram;
        return other;
    }

    public void render(float songTime) {
        Vector3f pos = MemoryPool.newVector3f(this.position);
        Quaternionf ori = MemoryPool.newQuaternionf(this.orientation);
        MirrorHandler.recordPlainCall((b, c) -> this._render((class_287)b, pos, ori, songTime, (Vector3f)c));
    }

    private void _render(class_287 buffer, Vector3f position, Quaternionf orientation, float songTime, Vector3f cameraPos) {
        Vector3f realOffset = this.towerOffset.rotate((Quaternionfc)orientation, MemoryPool.newVector3f());
        this.upVec.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)orientation);
        float[] heights = this.spectrogram.getLevels(songTime);
        for (int i = 0; i < this.towerCount; ++i) {
            int j = i;
            if (this.splitHalfway) {
                j = Math.max(1, Math.abs((int)((float)i - (float)this.towerCount / 2.0f)));
            }
            this.decayHeights[j] = Math.max(0.0f, this.decayHeights[j] - (0.02f + this.decayHeights[j] / 90.0f));
            float y = this.levelEasing.apply(Float.valueOf(Math.clamp(heights[j] / 30.0f, 0.0f, 1.0f))).floatValue() * this.maxHeight * this.levelModifier;
            if (j == 1) {
                y *= 0.8f;
            }
            this.decayHeights[j] = Math.max(this.decayHeights[j], y);
            y = this.decayHeights[j];
            Vector3f pos = MemoryPool.newVector3f(realOffset).mul((float)i).add((Vector3fc)position);
            Vector3f v0 = MemoryPool.newVector3f(-0.5f, 0.0f, -0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v1 = MemoryPool.newVector3f(-0.5f, 0.0f, 0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v2 = MemoryPool.newVector3f(0.5f, 0.0f, 0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v3 = MemoryPool.newVector3f(0.5f, 0.0f, -0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v0t = MemoryPool.newVector3f(-0.5f, this.baseHeight + y, -0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v1t = MemoryPool.newVector3f(-0.5f, this.baseHeight + y, 0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v2t = MemoryPool.newVector3f(0.5f, this.baseHeight + y, 0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f v3t = MemoryPool.newVector3f(0.5f, this.baseHeight + y, -0.5f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            List<Vector3f[]> faces = BeatCraftRenderer.getCubeFaces(v0, v1, v2, v3, v0t, v1t, v2t, v3t, false);
            for (Vector3f[] face : faces) {
                buffer.method_60830(face[0]).method_39415(-16777216);
                buffer.method_60830(face[1]).method_39415(-16777216);
                buffer.method_60830(face[2]).method_39415(-16777216);
                buffer.method_60830(face[3]).method_39415(-16777216);
            }
            MemoryPool.release(v0, v1, v2, v3, v0t, v1t, v2t, v3t);
            MemoryPool.release(pos);
        }
        MemoryPool.release(realOffset);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TowerStyle {
        Cuboid;

    }
}

