/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.logic;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.beatmap.data.CutDirection;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.logic.HapticsHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.logic.InputSystem;
import com.beatcraft.logic.Rank;
import com.beatcraft.logic.SwingState;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.menu.EndScreenData;
import com.beatcraft.render.DebugRenderer;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.object.PhysicalGameplayObject;
import com.beatcraft.render.object.PhysicalObstacle;
import com.beatcraft.render.object.PhysicalScorableObject;
import com.beatcraft.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.replay.PlayRecorder;
import com.beatcraft.replay.Replayer;
import com.beatcraft.utils.MathUtil;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;

@Environment(value=EnvType.CLIENT)
public class GameLogicHandler {
    private static int goodCuts = 0;
    private static int badCuts = 0;
    private static int misses = 0;
    private static double loseFCTime = 0.0;
    private static int combo = 0;
    private static int maxCombo = 0;
    private static int bonusModifier = 1;
    private static int modifierProgress = 0;
    private static int maxPossibleScore = 0;
    private static int score = 0;
    private static boolean failed = false;
    public static boolean noFail = false;
    public static int maxHealth = 100;
    public static float health = 50.0f;
    private static final int MISS_HP = 15;
    private static final int BADCUT_HP = 10;
    private static final int BOMB_HP = 15;
    private static final int WALL_HP = 10;
    private static final int HEAL_HP = 5;
    private static boolean inWall = false;
    public static Vector3f headPos = new Vector3f();
    public static Quaternionf headRot = new Quaternionf();
    public static boolean FPFC = false;
    private static UUID trackedPlayerUuid = null;
    public static final Random random = new Random();
    public static Vector3f rightSaberPos = new Vector3f();
    public static Vector3f leftSaberPos = new Vector3f();
    public static Quaternionf leftSaberRotation = new Quaternionf();
    public static Quaternionf rightSaberRotation = new Quaternionf();
    private static Vector3f previousLeftSaberPos = new Vector3f();
    private static Vector3f previousRightSaberPos = new Vector3f();
    private static Quaternionf previousLeftSaberRotation = new Quaternionf();
    private static Quaternionf previousRightSaberRotation = new Quaternionf();
    private static final SwingState leftSwingState = new SwingState(NoteType.RED);
    private static final SwingState rightSwingState = new SwingState(NoteType.BLUE);

    public static void trackPlayer(UUID uuid) {
        trackedPlayerUuid = uuid;
    }

    public static void untrack(UUID uuid) {
        if (trackedPlayerUuid == uuid) {
            trackedPlayerUuid = null;
            GameLogicHandler.unloadAll();
        }
    }

    public static boolean isTrackingClient() {
        return trackedPlayerUuid == null;
    }

    public static boolean isTracking(UUID uuid) {
        return trackedPlayerUuid == uuid;
    }

    public static void updateLeftSaber(Vector3f position, Quaternionf rotation) {
        previousLeftSaberPos = leftSaberPos;
        previousLeftSaberRotation = leftSaberRotation;
        leftSaberPos = position;
        leftSaberRotation = rotation;
    }

    public static void updateRightSaber(Vector3f position, Quaternionf rotation) {
        previousRightSaberPos = rightSaberPos;
        previousRightSaberRotation = rightSaberRotation;
        rightSaberPos = position;
        rightSaberRotation = rotation;
    }

    public static boolean isInWall() {
        return inWall;
    }

    public static void preUpdate(double deltaTime, float tickDelta) {
        inWall = false;
    }

    public static void update(double deltaTime, float tickDelta) {
        if (ClientDataHolderVR.getInstance().vr != null && ClientDataHolderVR.getInstance().vr.isActive() && !ClientDataHolderVR.getInstance().isFirstPass) {
            return;
        }
        assert (class_310.method_1551().field_1724 != null);
        headPos = class_310.method_1551().field_1724.method_30950(tickDelta).method_46409().add(0.0f, (float)(class_310.method_1551().field_1724.method_23320() - class_310.method_1551().field_1724.method_19538().field_1351), 0.0f);
        headRot.set((Quaternionfc)MirrorHandler.invCameraRotation).conjugate();
        if (FPFC) {
            Quaternionf rot = new Quaternionf().rotateY(-class_310.method_1551().field_1724.method_5705(tickDelta) * ((float)Math.PI / 180)).normalize().rotateX((90.0f + class_310.method_1551().field_1724.method_5695(tickDelta)) * ((float)Math.PI / 180)).normalize();
            rightSaberPos = new Vector3f((Vector3fc)headPos);
            leftSaberPos = new Vector3f((Vector3fc)headPos);
            rightSaberRotation = new Quaternionf((Quaternionfc)rot);
            leftSaberRotation = rot;
        }
        rightSwingState.updateSaber(rightSaberPos, rightSaberRotation, deltaTime);
        leftSwingState.updateSaber(leftSaberPos, leftSaberRotation, deltaTime);
        Vector3f leftEndpoint = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)leftSaberRotation).add((Vector3fc)leftSaberPos);
        Vector3f rightEndpoint = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)rightSaberRotation).add((Vector3fc)rightSaberPos);
        class_3545<Float, Vector3f> res = MathUtil.getLineDistance(leftSaberPos, leftEndpoint, rightSaberPos, rightEndpoint);
        if ((double)((Float)res.method_15442()).floatValue() <= 0.05) {
            HapticsHandler.vibrateLeft(0.2f, 1.0f);
            HapticsHandler.vibrateRight(0.2f, 1.0f);
            if (!FPFC) {
                BeatcraftParticleRenderer.spawnSparkParticles((Vector3f)res.method_15441(), new Vector3f(0.0f, 0.0f, 0.0f), 0.2f, 0.03f, random.nextInt(3, 5), -1, 0.02f);
            }
        }
        if (inWall) {
            GameLogicHandler.processDamage(10.0f * (float)deltaTime);
            GameLogicHandler.checkFail();
            GameLogicHandler.breakCombo();
        }
    }

    private static boolean matchAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return 225.0f < angle && angle < 315.0f;
    }

    public static Vector3f getPlaneNormal(Vector3f start, Vector3f end, Vector3f velocity) {
        Vector3f s1 = end.sub((Vector3fc)start, new Vector3f());
        Vector3f cross = s1.cross((Vector3fc)velocity, new Vector3f());
        return cross.normalize();
    }

    public static float distanceToOrigin(Vector3f planeIncident, Vector3f planeNormal) {
        return Math.abs(planeNormal.dot((Vector3fc)planeIncident)) / planeNormal.length();
    }

    private static <T extends GameplayObject> void checkSaber(PhysicalGameplayObject<T> note, Quaternionf saberRotation, Quaternionf previousSaberRotation, Vector3f saberPos, Vector3f previousSaberPos, NoteType saberColor) {
        Vector3f planeNormal;
        PhysicalScorableObject scorable;
        if (note.getContactColor() == saberColor.opposite()) {
            return;
        }
        Vector3f notePos = note.getWorldPos();
        Quaternionf inverted = new Quaternionf();
        note.getWorldRot().conjugate(inverted);
        Vector3f endpoint = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)saberRotation).add((Vector3fc)saberPos);
        Vector3f oldEndpoint = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)previousSaberRotation).add((Vector3fc)previousSaberPos);
        Vector3f trueDiff = endpoint.sub((Vector3fc)oldEndpoint, new Vector3f());
        Vector3f trueEndpoint = new Vector3f((Vector3fc)endpoint);
        Vector3f local_hand = new Vector3f((Vector3fc)saberPos).sub((Vector3fc)notePos).rotate((Quaternionfc)inverted);
        endpoint.sub((Vector3fc)notePos).rotate((Quaternionfc)inverted);
        oldEndpoint.sub((Vector3fc)notePos).rotate((Quaternionfc)inverted);
        Vector3f diff = endpoint.sub((Vector3fc)oldEndpoint, new Vector3f());
        float angle = MathUtil.getVectorAngleDegrees(new Vector2f(diff.x, diff.y).normalize());
        Hitbox goodCutHitbox = note.getGoodCutBounds();
        Hitbox badCutHitbox = note.getBadCutBounds();
        Hitbox accurateHitbox = note.getAccurateHitbox();
        if (DebugRenderer.doDebugRendering) {
            if (DebugRenderer.debugSaberRendering) {
                DebugRenderer.renderParticle(saberPos, DebugRenderer.GREEN_DUST);
                DebugRenderer.renderParticle(notePos, DebugRenderer.ORANGE_DUST);
                DebugRenderer.renderParticle(trueEndpoint, DebugRenderer.MAGENTA_DUST);
                DebugRenderer.renderLine(trueEndpoint, trueEndpoint.add((Vector3fc)trueDiff, new Vector3f()), -16711936, 0x7FFF0000);
                DebugRenderer.renderLine(endpoint, endpoint.add((Vector3fc)diff, new Vector3f()), 0x7F00FF00, 671023104);
                int c = 0x7F000000 + (saberColor == NoteType.BLUE ? 255 : 0xFF0000);
                DebugRenderer.renderLine(local_hand, endpoint, c, Integer.MAX_VALUE);
                DebugRenderer.renderHitbox(goodCutHitbox, new Vector3f(), new Quaternionf(), 65280);
                DebugRenderer.renderHitbox(badCutHitbox, new Vector3f(), new Quaternionf(), 0xFF0000);
            }
            if (DebugRenderer.renderHitboxes) {
                DebugRenderer.renderHitbox(goodCutHitbox, notePos, note.getWorldRot(), 65280);
                DebugRenderer.renderHitbox(badCutHitbox, notePos, note.getWorldRot(), 0xFF0000);
                DebugRenderer.renderHitbox(accurateHitbox, notePos, note.getWorldRot(), 0xFFFF00);
            }
        }
        assert (class_310.method_1551().field_1724 != null);
        if (note instanceof PhysicalScorableObject && (scorable = (PhysicalScorableObject)((Object)note)).score$getData().score$getNoteType() == saberColor && goodCutHitbox.checkCollision(local_hand, endpoint)) {
            if (saberColor == NoteType.RED) {
                leftSwingState.startSparkEffect();
                HapticsHandler.vibrateLeft(1.0f, 0.075f * (float)class_310.method_1551().method_47599());
            } else {
                rightSwingState.startSparkEffect();
                HapticsHandler.vibrateRight(1.0f, 0.075f * (float)class_310.method_1551().method_47599());
            }
            if (scorable.score$getData().score$getCutDirection() == CutDirection.DOT || GameLogicHandler.matchAngle(angle)) {
                if (saberColor == NoteType.BLUE) {
                    rightSwingState.followThrough(scorable);
                } else {
                    leftSwingState.followThrough(scorable);
                }
                planeNormal = GameLogicHandler.getPlaneNormal(local_hand, endpoint, diff);
                float distance = GameLogicHandler.distanceToOrigin(local_hand, planeNormal);
                int points = (int)Math.clamp(15.0f * (1.0f - MathUtil.inverseLerp(0.0f, 0.25f, distance)), 0.0f, 15.0f);
                scorable.score$setCutResult(CutResult.goodCut(scorable, points, (int)(saberColor == NoteType.BLUE ? rightSwingState.getSwingAngle() : leftSwingState.getSwingAngle()), notePos));
                note.spawnDebris(notePos.add((Vector3fc)new Vector3f(-0.25f, -0.25f, -0.25f).rotate((Quaternionfc)note.getWorldRot())), note.getWorldRot(), scorable.score$getData().score$getNoteType(), local_hand.add(0.25f, 0.25f, 0.25f, new Vector3f()), planeNormal);
                scorable.score$cutNote();
            }
        }
        if (badCutHitbox.checkCollision(local_hand, endpoint) && note.getCutResult().type != 1) {
            if (note instanceof PhysicalScorableObject) {
                PhysicalScorableObject scorable2 = (PhysicalScorableObject)((Object)note);
                if (!GameLogicHandler.matchAngle(angle)) {
                    scorable2.score$setCutResult(CutResult.badCut(scorable2, notePos));
                    scorable2.score$getCutResult().finalizeScore();
                    planeNormal = GameLogicHandler.getPlaneNormal(local_hand, endpoint, diff);
                    note.spawnDebris(notePos.add((Vector3fc)new Vector3f(-0.25f, -0.25f, -0.25f).rotate((Quaternionfc)note.getWorldRot())), note.getWorldRot(), scorable2.score$getData().score$getNoteType(), local_hand.add(0.25f, 0.25f, 0.25f, new Vector3f()), planeNormal);
                }
            } else {
                GameLogicHandler.hitBomb();
            }
            if (saberColor == NoteType.RED) {
                HapticsHandler.vibrateLeft(1.0f, 0.075f * (float)class_310.method_1551().method_47599());
            } else {
                HapticsHandler.vibrateRight(1.0f, 0.075f * (float)class_310.method_1551().method_47599());
            }
            note.cutNote();
            GameLogicHandler.breakCombo();
        }
    }

    public static <T extends GameplayObject> void checkNote(PhysicalGameplayObject<T> note) {
        if ((double)rightSaberPos.distance((Vector3fc)note.getWorldPos()) <= 1.2 + (double)note.getCollisionDistance()) {
            GameLogicHandler.checkSaber(note, rightSaberRotation, previousRightSaberRotation, rightSaberPos, previousRightSaberPos, NoteType.BLUE);
        }
        if ((double)leftSaberPos.distance((Vector3fc)note.getWorldPos()) <= 1.2 + (double)note.getCollisionDistance()) {
            GameLogicHandler.checkSaber(note, leftSaberRotation, previousLeftSaberRotation, leftSaberPos, previousLeftSaberPos, NoteType.RED);
        }
    }

    private static void checkSaberAgainstObstacle(Hitbox hitbox, Vector3f position, Quaternionf inverted, Vector3f saberPos, Quaternionf saberRotation, NoteType saber) {
        Vector3f endpoint = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)saberRotation).add((Vector3fc)saberPos);
        Vector3f local_hand = new Vector3f((Vector3fc)saberPos).sub((Vector3fc)position).rotate((Quaternionfc)inverted);
        endpoint.sub((Vector3fc)position).rotate((Quaternionfc)inverted);
        if (hitbox.checkCollision(local_hand, endpoint)) {
            if (saber == NoteType.BLUE) {
                HapticsHandler.vibrateRight(0.25f, 1.0f);
            } else {
                HapticsHandler.vibrateLeft(0.25f, 1.0f);
            }
        }
    }

    public static void checkObstacle(PhysicalObstacle obstacle, Vector3f position, Quaternionf orientation) {
        Hitbox hitbox = obstacle.getBounds();
        Quaternionf inverted = new Quaternionf();
        orientation.invert(inverted);
        GameLogicHandler.checkSaberAgainstObstacle(hitbox, position, inverted, rightSaberPos, rightSaberRotation, NoteType.BLUE);
        GameLogicHandler.checkSaberAgainstObstacle(hitbox, position, inverted, leftSaberPos, leftSaberRotation, NoteType.RED);
        Vector3f localHeadPos = new Vector3f((Vector3fc)headPos).sub((Vector3fc)position).rotate((Quaternionfc)inverted);
        if (!inWall) {
            inWall = hitbox.isPointInHitbox(localHeadPos);
        }
    }

    public static void process(CutResult cut) {
        switch (cut.type) {
            case 3: {
                if (misses == 0 && badCuts == 0) {
                    loseFCTime = (double)System.nanoTime() / 1.0E9;
                }
                GameLogicHandler.addMiss();
                GameLogicHandler.breakCombo();
                GameLogicHandler.addScore(0, 115);
                Vector3f startPos = cut.contactPosition.mul(1.0f, 0.0f, 1.0f, new Vector3f());
                Vector3f endPos = startPos.add((Vector3fc)new Vector3f(0.0f, 0.1f, 7.0f).rotate((Quaternionfc)cut.note.score$getLaneRotation().invert(new Quaternionf())), new Vector3f());
                HUDRenderer.postScore(-1, startPos, endPos, cut.note.score$getLaneRotation());
                break;
            }
            case 1: {
                int pre_swing = (int)(Math.clamp(MathUtil.inverseLerp(0.0f, 100.0f, cut.preSwingAngle), 0.0f, 1.0f) * 70.0f);
                int post_swing = (int)(Math.clamp(MathUtil.inverseLerp(0.0f, 60.0f, cut.followThroughAngle), 0.0f, 1.0f) * 30.0f);
                int finalScore = pre_swing + post_swing + cut.sliceScore;
                GameLogicHandler.addGoodCut();
                GameLogicHandler.incrementCombo();
                GameLogicHandler.addScore(finalScore, 115);
                Vector3f startPos = cut.contactPosition.mul(1.0f, 0.0f, 1.0f, new Vector3f());
                Vector3f endPos = startPos.add((Vector3fc)new Vector3f(0.0f, 0.1f, 7.0f).rotate((Quaternionfc)cut.note.score$getLaneRotation().invert(new Quaternionf())), new Vector3f());
                HUDRenderer.postScore(finalScore, startPos, endPos, cut.note.score$getLaneRotation());
                break;
            }
            case 2: {
                if (misses == 0 && badCuts == 0) {
                    loseFCTime = (double)System.nanoTime() / 1.0E9;
                }
                GameLogicHandler.addBadcut();
                GameLogicHandler.breakCombo();
                GameLogicHandler.addScore(0, 115);
                Vector3f startPos = cut.contactPosition.mul(1.0f, 0.0f, 1.0f, new Vector3f());
                Vector3f endPos = startPos.add((Vector3fc)new Vector3f(0.0f, 0.1f, 7.0f).rotate((Quaternionfc)cut.note.score$getLaneRotation().invert(new Quaternionf())), new Vector3f());
                HUDRenderer.postScore(0, startPos, endPos, cut.note.score$getLaneRotation());
            }
        }
    }

    public static float getComboBarOpacity() {
        if (badCuts == 0 && misses == 0) {
            return 1.0f;
        }
        return 1.0f - (float)Math.clamp(MathUtil.inverseLerp(loseFCTime, loseFCTime + 0.3, (double)System.nanoTime() / 1.0E9), 0.0, 1.0);
    }

    public static int getGoodCuts() {
        return goodCuts;
    }

    public static int getCombo() {
        return combo;
    }

    public static int getMaxCombo() {
        return maxCombo;
    }

    public static int getBonusModifier() {
        return bonusModifier;
    }

    public static int getScore() {
        return score;
    }

    public static int getMaxPossibleScore() {
        return maxPossibleScore;
    }

    public static float getHealthPercentage() {
        return health / (float)maxHealth;
    }

    public static void addGoodCut() {
        ++goodCuts;
        if (!(maxHealth != 100 || failed && noFail)) {
            health = Math.min((float)maxHealth, health + 5.0f);
        }
    }

    private static void processDamage(float damage) {
        health = maxHealth == 100 ? (health -= damage) : (maxHealth == 4 ? (health -= 1.0f) : 0.0f);
    }

    private static void addMiss() {
        ++misses;
        if (failed && noFail) {
            return;
        }
        GameLogicHandler.processDamage(15.0f);
        GameLogicHandler.checkFail();
    }

    private static void addBadcut() {
        ++badCuts;
        if (failed && noFail) {
            return;
        }
        GameLogicHandler.processDamage(10.0f);
        GameLogicHandler.checkFail();
    }

    private static void hitBomb() {
        if (failed && noFail) {
            return;
        }
        GameLogicHandler.processDamage(15.0f);
        GameLogicHandler.checkFail();
    }

    private static void checkFail() {
        if (health <= 0.0f) {
            health = 0.0f;
            failed = true;
            if (!noFail) {
                HUDRenderer.endScreenPanel.setFailed();
                HUDRenderer.scene = HUDRenderer.MenuScene.EndScreen;
                try {
                    PlayRecorder.save();
                }
                catch (IOException e) {
                    BeatCraft.LOGGER.error("Error saving recording", (Throwable)e);
                }
                GameLogicHandler.unloadAll();
            }
        }
    }

    public static void incrementCombo() {
        maxCombo = Math.max(++combo, maxCombo);
        if (bonusModifier < 8 && ++modifierProgress == bonusModifier) {
            bonusModifier *= 2;
            modifierProgress = 0;
        }
    }

    public static float getModifierPercentage() {
        return (float)modifierProgress / (float)bonusModifier;
    }

    public static void breakCombo() {
        combo = 0;
        modifierProgress = 0;
        if (bonusModifier > 1) {
            bonusModifier /= 2;
        }
    }

    public static void addScore(int actual, int max) {
        score += actual * bonusModifier;
        maxPossibleScore += max * bonusModifier;
    }

    public static float getAccuracy() {
        float acc = (float)score / (float)maxPossibleScore;
        return Float.isNaN(acc) ? 1.0f : acc;
    }

    public static Rank getRank() {
        float acc = GameLogicHandler.getAccuracy() * 100.0f;
        if (acc < 20.0f) {
            return Rank.E;
        }
        if (acc < 35.0f) {
            return Rank.D;
        }
        if (acc < 50.0f) {
            return Rank.C;
        }
        if (acc < 65.0f) {
            return Rank.B;
        }
        if (acc < 80.0f) {
            return Rank.A;
        }
        if (acc < 90.0f) {
            return Rank.S;
        }
        return Rank.SS;
    }

    public static void reset() {
        score = 0;
        maxPossibleScore = 0;
        combo = 0;
        maxCombo = 0;
        bonusModifier = 1;
        goodCuts = 0;
        loseFCTime = 0.0;
        badCuts = 0;
        misses = 0;
        failed = false;
        health = maxHealth == 100 ? 50.0f : (maxHealth == 4 ? 4.0f : 1.0f);
        inWall = false;
        MemoryPool.clear();
    }

    public static void triggerSongEnd() {
        HUDRenderer.scene = HUDRenderer.MenuScene.EndScreen;
        HUDRenderer.endScreenPanel.setData(new EndScreenData(GameLogicHandler.getScore(), GameLogicHandler.getRank(), GameLogicHandler.getMaxCombo(), goodCuts, GameLogicHandler.getAccuracy() * 100.0f, goodCuts + badCuts + misses));
        try {
            PlayRecorder.save();
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Error saving recording", (Throwable)e);
        }
        GameLogicHandler.unloadAll();
    }

    public static void unloadAll() {
        PlayRecorder.reset();
        Replayer.reset();
        BeatmapPlayer.reset();
        BeatmapAudioPlayer.unload();
        GameLogicHandler.reset();
    }

    public static boolean isPaused() {
        return HUDRenderer.scene == HUDRenderer.MenuScene.Paused;
    }

    public static void unpauseMap() {
        InputSystem.lockHotbar();
        CompletableFuture.runAsync(() -> {
            HUDRenderer.scene = HUDRenderer.MenuScene.InGame;
            double start = (double)System.nanoTime() / 1.0E9;
            while ((double)System.nanoTime() / 1.0E9 - start < 1.0) {
                double dt = 1.0 - (double)System.nanoTime() / 1.0E9;
                if (HUDRenderer.scene == HUDRenderer.MenuScene.InGame) continue;
                return;
            }
            if (HUDRenderer.scene != HUDRenderer.MenuScene.InGame) {
                return;
            }
            BeatmapPlayer.play();
        });
    }

    public static void pauseMap() {
        InputSystem.unlockHotbar();
        HUDRenderer.scene = HUDRenderer.MenuScene.Paused;
        BeatmapPlayer.pause();
    }

    @Environment(value=EnvType.CLIENT)
    public static class CutResult {
        private final int type;
        private static final int GOOD_CUT = 1;
        private static final int BAD_CUT = 2;
        private static final int NO_HIT = 3;
        private final int preSwingAngle;
        private int followThroughAngle = 0;
        private final int sliceScore;
        private Vector3f contactPosition;
        private boolean finalized = false;
        private PhysicalScorableObject note;

        private CutResult(PhysicalScorableObject note, int preSwing, int sliceScore, Vector3f pos, int type) {
            this.note = note;
            this.preSwingAngle = preSwing;
            this.sliceScore = sliceScore;
            this.contactPosition = new Vector3f((Vector3fc)pos);
            this.type = type;
        }

        public static CutResult goodCut(PhysicalScorableObject note, int sliceScore, int preSwingAngle, Vector3f pos) {
            return new CutResult(note, preSwingAngle, sliceScore, pos, 1);
        }

        public static CutResult badCut(PhysicalScorableObject note, Vector3f pos) {
            return new CutResult(note, 0, 0, pos, 2);
        }

        public static CutResult noHit(PhysicalScorableObject note) {
            return new CutResult(note, 0, 0, new Vector3f(), 3);
        }

        public void setFollowThroughAngle(int angle) {
            this.followThroughAngle = angle;
            this.finalizeScore();
        }

        public void setContactPosition(Vector3f pos) {
            this.contactPosition = new Vector3f((Vector3fc)pos);
        }

        public int getPreSwingAngle() {
            return this.preSwingAngle;
        }

        public void finalizeScore() {
            if (this.finalized) {
                return;
            }
            this.finalized = true;
            GameLogicHandler.process(this);
        }
    }
}

