/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.networking;

import com.beatcraft.BeatCraft;
import com.beatcraft.environment.StructurePlacer;
import com.beatcraft.networking.c2s.BeatSyncC2SPayload;
import com.beatcraft.networking.c2s.MapSyncC2SPayload;
import com.beatcraft.networking.c2s.PlaceEnvironmentStructureC2SPayload;
import com.beatcraft.networking.c2s.SaberSyncC2SPayload;
import com.beatcraft.networking.c2s.SongPauseC2SPayload;
import com.beatcraft.networking.c2s.SpeedSyncC2SPayload;
import com.beatcraft.networking.s2c.BeatSyncS2CPayload;
import com.beatcraft.networking.s2c.MapSyncS2CPayload;
import com.beatcraft.networking.s2c.PlayerDisconnectS2CPayload;
import com.beatcraft.networking.s2c.SaberSyncS2CPayload;
import com.beatcraft.networking.s2c.SongPauseS2CPayload;
import com.beatcraft.networking.s2c.SpeedSyncS2CPayload;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class BeatCraftNetworking {
    public static final class_2960 SABER_SYNC_S2C = class_2960.method_60655((String)"beatcraft", (String)"saber_sync_s2c");
    public static final class_2960 MAP_SYNC_S2C = class_2960.method_60655((String)"beatcraft", (String)"map_sync_s2c");
    public static final class_2960 BEAT_SYNC_S2C = class_2960.method_60655((String)"beatcraft", (String)"beat_sync_s2c");
    public static final class_2960 PLAYER_DISCONNECT_S2C = class_2960.method_60655((String)"beatcraft", (String)"player_disconnect_s2c");
    public static final class_2960 SPEED_SYNC_S2C = class_2960.method_60655((String)"beatcraft", (String)"speed_sync_s2c");
    public static final class_2960 SONG_PAUSE_S2C = class_2960.method_60655((String)"beatcraft", (String)"song_pause_s2c");
    public static final class_2960 SABER_SYNC_C2S = class_2960.method_60655((String)"beatcraft", (String)"saber_sync_c2s");
    public static final class_2960 MAP_SYNC_C2S = class_2960.method_60655((String)"beatcraft", (String)"map_sync_c2s");
    public static final class_2960 BEAT_SYNC_C2S = class_2960.method_60655((String)"beatcraft", (String)"beat_sync_c2s");
    public static final class_2960 SPEED_SYNC_C2S = class_2960.method_60655((String)"beatcraft", (String)"speed_sync_c2s");
    public static final class_2960 SONG_PAUSE_C2S = class_2960.method_60655((String)"beatcraft", (String)"song_pause_c2s");
    public static final class_2960 PLACE_ENVIRONMENT_C2S = class_2960.method_60655((String)"beatcraft", (String)"place_environment_c2s");

    public static void init() {
        PayloadTypeRegistry.playS2C().register(SaberSyncS2CPayload.ID, SaberSyncS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(MapSyncS2CPayload.ID, MapSyncS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(BeatSyncS2CPayload.ID, BeatSyncS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayerDisconnectS2CPayload.ID, PlayerDisconnectS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpeedSyncS2CPayload.ID, SpeedSyncS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SongPauseS2CPayload.ID, SongPauseS2CPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SaberSyncC2SPayload.ID, SaberSyncC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(MapSyncC2SPayload.ID, MapSyncC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BeatSyncC2SPayload.ID, BeatSyncC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SpeedSyncC2SPayload.ID, SpeedSyncC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SongPauseC2SPayload.ID, SongPauseC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PlaceEnvironmentStructureC2SPayload.ID, PlaceEnvironmentStructureC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(SaberSyncC2SPayload.ID, BeatCraftNetworking::handleSaberSyncPayload);
        ServerPlayNetworking.registerGlobalReceiver(MapSyncC2SPayload.ID, BeatCraftNetworking::handleMapSyncPayload);
        ServerPlayNetworking.registerGlobalReceiver(BeatSyncC2SPayload.ID, BeatCraftNetworking::handleBeatSyncPayload);
        ServerPlayNetworking.registerGlobalReceiver(SpeedSyncC2SPayload.ID, BeatCraftNetworking::handleSpeedSyncPayload);
        ServerPlayNetworking.registerGlobalReceiver(SongPauseC2SPayload.ID, BeatCraftNetworking::handlePausePayload);
        ServerPlayNetworking.registerGlobalReceiver(PlaceEnvironmentStructureC2SPayload.ID, BeatCraftNetworking::placeStructure);
    }

    private static void handleSaberSyncPayload(SaberSyncC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sending_player = context.player();
            UUID uuid = sending_player.method_5667();
            PlayerLookup.tracking((class_1297)sending_player).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)new SaberSyncS2CPayload(uuid, payload.leftPos(), payload.leftRot(), payload.rightPos(), payload.rightRot(), payload.headPos(), payload.headRot())));
        });
    }

    private static void handleMapSyncPayload(MapSyncC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            UUID uuid = player.method_5667();
            BeatCraft.currentTrackId = payload.uid();
            BeatCraft.currentTrackedPlayer = uuid;
            BeatCraft.currentSet = payload.set();
            BeatCraft.currentDiff = payload.diff();
            PlayerLookup.all((MinecraftServer)context.server()).forEach(arg_0 -> BeatCraftNetworking.lambda$handleMapSyncPayload$2((class_1657)player, uuid, payload, arg_0));
        });
    }

    private static void handleBeatSyncPayload(BeatSyncC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            if (player.method_5667() == BeatCraft.currentTrackedPlayer) {
                BeatCraft.currentTrackedPlayer = null;
                BeatCraft.currentTrackId = null;
                BeatCraft.currentSet = null;
                BeatCraft.currentDiff = null;
            }
            PlayerLookup.tracking((class_1297)player).forEach(pl -> ServerPlayNetworking.send((class_3222)pl, (class_8710)new BeatSyncS2CPayload(payload.beat())));
        });
    }

    private static void handleSpeedSyncPayload(SpeedSyncC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            PlayerLookup.tracking((class_1297)player).forEach(pl -> ServerPlayNetworking.send((class_3222)pl, (class_8710)new SpeedSyncS2CPayload(payload.speed())));
        });
    }

    private static void handlePausePayload(SongPauseC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            PlayerLookup.tracking((class_1297)player).forEach(pl -> ServerPlayNetworking.send((class_3222)pl, (class_8710)new SongPauseS2CPayload()));
        });
    }

    private static void placeStructure(PlaceEnvironmentStructureC2SPayload payload, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_3218 world = (class_3218)player.method_37908();
            String struct = payload.struct();
            StructurePlacer.placeStructure(struct, world);
        });
    }

    private static /* synthetic */ void lambda$handleMapSyncPayload$2(class_1657 player, UUID uuid, MapSyncC2SPayload payload, class_3222 pl) {
        if (pl == player) {
            return;
        }
        ServerPlayNetworking.send((class_3222)pl, (class_8710)new MapSyncS2CPayload(uuid, payload.uid(), payload.set(), payload.diff()));
    }
}

