/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.beatcraft.render.effect.Bloomfog;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.effect.ObstacleGlowRenderer;
import com.beatcraft.render.mesh.MeshLoader;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class BeatCraftRenderer {
    public static Bloomfog bloomfog;
    private static final ArrayList<Consumer<class_4597>> earlyRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> bloomfogPosColCalls;
    private static final ArrayList<Runnable> renderCalls;
    private static final ArrayList<TriConsumer<class_287, Vector3f, Integer>> obstacleRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> noteRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> arrowRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> laserRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> laserPreRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> lightRenderCalls;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> arcRenderCalls;
    public static class_5944 noteShader;
    public static class_5944 arrowShader;
    public static class_5944 heartHealthShader;

    public static void init() {
        bloomfog = Bloomfog.create();
        try {
            noteShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "note_shader", class_290.field_1575);
            arrowShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "arrow_shader", class_290.field_1575);
            heartHealthShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "health_hearts", class_290.field_1575);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateBloomfogSize(int width, int height) {
        if (bloomfog != null && BeatCraftRenderer.bloomfog.framebuffer != null) {
            bloomfog.resize(width, height, true);
        }
    }

    public static void onRender(class_4587 matrices, class_4184 camera, float tickDelta) {
        BeatmapPlayer.onRender(matrices, camera, tickDelta);
    }

    public static void recordNoteRenderCall(BiConsumer<class_287, Vector3f> call) {
        noteRenderCalls.add(call);
    }

    public static void recordArrowRenderCall(BiConsumer<class_287, Vector3f> call) {
        arrowRenderCalls.add(call);
    }

    public static void recordObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        obstacleRenderCalls.add(call);
    }

    public static void recordRenderCall(Runnable call) {
        renderCalls.add(call);
    }

    public static void recordArcRenderCall(BiConsumer<class_287, Vector3f> call) {
        arcRenderCalls.add(call);
    }

    public static void recordLaserRenderCall(BiConsumer<class_287, Vector3f> call) {
        laserRenderCalls.add(call);
    }

    public static void recordLaserPreRenderCall(BiConsumer<class_287, Vector3f> call) {
        laserPreRenderCalls.add(call);
    }

    public static void recordLightRenderCall(BiConsumer<class_287, Vector3f> call) {
        lightRenderCalls.add(call);
    }

    public static void recordEarlyRenderCall(Consumer<class_4597> call) {
        earlyRenderCalls.add(call);
    }

    public static void recordBloomfogPosColCall(BiConsumer<class_287, Vector3f> call) {
        bloomfogPosColCalls.add(call);
    }

    private static void renderEarly(class_4597 vcp) {
        for (Consumer<class_4597> call : earlyRenderCalls) {
            call.accept(vcp);
        }
        earlyRenderCalls.clear();
    }

    private static void renderObstacles(class_289 tessellator, Vector3f cameraPos) {
        if (BeatmapPlayer.currentBeatmap == null) {
            obstacleRenderCalls.clear();
            return;
        }
        int color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        for (TriConsumer<class_287, Vector3f, Integer> call : obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        obstacleRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            ObstacleGlowRenderer.grabScreen();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            class_6367 scene = ObstacleGlowRenderer.framebuffer;
            RenderSystem.setShader(() -> ObstacleGlowRenderer.distortionShader);
            RenderSystem.setShaderTexture((int)0, (int)scene.method_30277());
            ObstacleGlowRenderer.distortionShader.method_35785("Time").method_1251((float)System.nanoTime() / 1.0E9f);
            buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
            class_286.method_43433((class_9801)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.disableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }

    private static void renderBloomfogPosCol(class_289 tessellator, Vector3f cameraPos) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (BiConsumer<class_287, Vector3f> call : bloomfogPosColCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        bloomfogPosColCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            bloomfog.loadTex();
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
    }

    private static void renderLightDepth(class_289 tessellator, Vector3f cameraPos) {
        BeatCraftRenderer.bloomfog.overrideBuffer = true;
        BeatCraftRenderer.bloomfog.overrideFramebuffer = Bloomfog.lightDepth;
        Bloomfog.lightDepth.method_1235(true);
        Bloomfog.lightDepth.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        Bloomfog.lightDepth.method_1230(class_310.field_1703);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (BiConsumer<class_287, Vector3f> call : lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            class_286.method_43433((class_9801)buff);
        }
        Bloomfog.lightDepth.method_1240();
        BeatCraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatCraftRenderer.bloomfog.overrideBuffer = false;
        class_310.method_1551().method_1522().method_1235(true);
    }

    private static void renderBackgroundLights(class_289 tessellator, Vector3f cameraPos, Matrix4f worldTransform) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(() -> Bloomfog.backlightsPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (BiConsumer<class_287, Vector3f> call : lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            Bloomfog.backlightsPositionColorShader.method_34583("Sampler0", (Object)Bloomfog.lightDepth.method_30278());
            RenderSystem.setShaderTexture((int)0, (int)Bloomfog.lightDepth.method_30278());
            Bloomfog.backlightsPositionColorShader.method_35785("WorldTransform").method_1250(worldTransform);
            class_286.method_43433((class_9801)buff);
        }
    }

    private static void renderEnvironmentLights(class_289 tessellator, Vector3f cameraPos) {
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        worldTransform.rotate((Quaternionfc)MirrorHandler.invCameraRotation.conjugate(new Quaternionf()));
        BeatCraftRenderer.renderLightDepth(tessellator, cameraPos);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(() -> Bloomfog.backlightsPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (BiConsumer<class_287, Vector3f> call : lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        lightRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            Bloomfog.backlightsPositionColorShader.method_34583("Sampler0", (Object)Bloomfog.lightDepth.method_30278());
            RenderSystem.setShaderTexture((int)0, (int)Bloomfog.lightDepth.method_30278());
            Bloomfog.backlightsPositionColorShader.method_35785("WorldTransform").method_1250(worldTransform);
            class_286.method_43433((class_9801)buff);
        }
        RenderSystem.defaultBlendFunc();
    }

    private static void renderNotes(class_289 tessellator, Vector3f cameraPos) {
        class_287 triBuffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        int oldTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShader(() -> noteShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.NOTE_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : noteRenderCalls) {
            try {
                renderCall.accept((Object)triBuffer, (Object)cameraPos);
            }
            catch (Exception e) {
                BeatCraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        class_9801 triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        triBuffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(() -> arrowShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.ARROW_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : arrowRenderCalls) {
            try {
                renderCall.accept((Object)triBuffer, (Object)cameraPos);
            }
            catch (Exception e) {
                BeatCraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldTexture);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        noteRenderCalls.clear();
        arrowRenderCalls.clear();
    }

    private static void renderFloorLightsPhase1(class_289 tessellator, Vector3f cameraPos) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : laserPreRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        laserPreRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderFloorLights(class_289 tessellator, Vector3f cameraPos) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : laserRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        laserRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderArcs(class_289 tessellator, Vector3f cameraPos) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        for (BiConsumer<class_287, Vector3f> call : arcRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        arcRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34540);
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
        }
    }

    public static void earlyRender(class_4597 vcp) {
        class_289 tessellator = class_289.method_1348();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Vector3f cameraPos = camera.method_19326().method_46409();
        BeatCraftRenderer.renderEarly(vcp);
        BeatCraftRenderer.renderBloomfogPosCol(tessellator, cameraPos);
        BeatCraftRenderer.renderEnvironmentLights(tessellator, cameraPos);
        BeatCraftRenderer.renderNotes(tessellator, cameraPos);
        BeatCraftRenderer.renderFloorLightsPhase1(tessellator, cameraPos);
        BeatCraftRenderer.renderObstacles(tessellator, cameraPos);
        BeatCraftRenderer.renderFloorLights(tessellator, cameraPos);
    }

    public static void render() {
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        BeatCraftRenderer.renderArcs(class_289.method_1348(), cameraPos);
        for (Runnable renderCall : renderCalls) {
            try {
                renderCall.run();
            }
            catch (Exception e) {
                BeatCraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        renderCalls.clear();
        BeatCraftRenderer.renderFootPosIndicator();
    }

    private static void renderFootPosIndicator() {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Vector3f camPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        int col = BeatmapPlayer.currentBeatmap == null ? Integer.MAX_VALUE : 0x38FFFFFF;
        float height = 0.01f;
        for (int i = 0; i < 2; ++i) {
            float x = ((float)i - 0.5f) * 0.25f;
            buffer.method_60830(MemoryPool.newVector3f(x - 0.1f, height, -0.1f).sub((Vector3fc)camPos)).method_39415(col);
            buffer.method_60830(MemoryPool.newVector3f(x - 0.1f, height, 0.1f).sub((Vector3fc)camPos)).method_39415(col);
            buffer.method_60830(MemoryPool.newVector3f(x + 0.1f, height, 0.1f).sub((Vector3fc)camPos)).method_39415(col);
            buffer.method_60830(MemoryPool.newVector3f(x + 0.1f, height, -0.1f).sub((Vector3fc)camPos)).method_39415(col);
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    public static List<Vector3f[]> getGlowingQuadAsTris(Vector2f quadSize, float glowSpread) {
        ArrayList<Vector3f[]> tris = new ArrayList<Vector3f[]>();
        float halfWidth = quadSize.x / 2.0f;
        float halfHeight = quadSize.y / 2.0f;
        float outerHalfWidth = halfWidth + glowSpread;
        float outerHalfHeight = halfHeight + glowSpread;
        Vector3f topLeftOuter = new Vector3f(-outerHalfWidth, outerHalfHeight, 0.0f);
        Vector3f topRightOuter = new Vector3f(outerHalfWidth, outerHalfHeight, 0.0f);
        Vector3f bottomLeftOuter = new Vector3f(-outerHalfWidth, -outerHalfHeight, 0.0f);
        Vector3f bottomRightOuter = new Vector3f(outerHalfWidth, -outerHalfHeight, 0.0f);
        Vector3f topLeftInner = new Vector3f(-halfWidth, halfHeight, 1.0f);
        Vector3f topRightInner = new Vector3f(halfWidth, halfHeight, 1.0f);
        Vector3f bottomLeftInner = new Vector3f(-halfWidth, -halfHeight, 1.0f);
        Vector3f bottomRightInner = new Vector3f(halfWidth, -halfHeight, 1.0f);
        tris.add(new Vector3f[]{topLeftInner, bottomLeftInner, bottomRightInner});
        tris.add(new Vector3f[]{topLeftInner, bottomRightInner, topRightInner});
        tris.add(new Vector3f[]{topLeftOuter, topLeftInner, topRightInner});
        tris.add(new Vector3f[]{topLeftOuter, topRightInner, topRightOuter});
        tris.add(new Vector3f[]{bottomLeftInner, bottomLeftOuter, bottomRightOuter});
        tris.add(new Vector3f[]{bottomLeftInner, bottomRightOuter, bottomRightInner});
        tris.add(new Vector3f[]{topLeftInner, topLeftOuter, bottomLeftOuter});
        tris.add(new Vector3f[]{topLeftInner, bottomLeftOuter, bottomLeftInner});
        tris.add(new Vector3f[]{bottomRightInner, bottomRightOuter, topRightOuter});
        tris.add(new Vector3f[]{bottomRightInner, topRightOuter, topRightInner});
        return tris;
    }

    public static List<Vector3f[]> getCubeFaces(Vector3f vxyz, Vector3f vxyZ, Vector3f vXyZ, Vector3f vXyz, Vector3f vxYz, Vector3f vxYZ, Vector3f vXYZ, Vector3f vXYz, boolean includeBottomFace) {
        ArrayList<Vector3f[]> faces = new ArrayList<Vector3f[]>();
        faces.add(new Vector3f[]{vXYz, vXYZ, vxYZ, vxYz});
        faces.add(new Vector3f[]{vxyZ, vXyZ, vXYZ, vxYZ});
        faces.add(new Vector3f[]{vXyz, vxyz, vxYz, vXYz});
        faces.add(new Vector3f[]{vxyz, vxyZ, vxYZ, vxYz});
        faces.add(new Vector3f[]{vXyZ, vXyz, vXYz, vXYZ});
        if (includeBottomFace) {
            faces.add(new Vector3f[]{vxyz, vXyz, vXyZ, vxyZ});
        }
        return faces;
    }

    public static List<Vector3f[]> getCubeEdges(Vector3f minPos, Vector3f maxPos) {
        int[][] edgeIndices;
        ArrayList<Vector3f[]> edges = new ArrayList<Vector3f[]>();
        Vector3f[] corners = new Vector3f[]{MemoryPool.newVector3f(minPos.x, minPos.y, minPos.z), MemoryPool.newVector3f(maxPos.x, minPos.y, minPos.z), MemoryPool.newVector3f(maxPos.x, maxPos.y, minPos.z), MemoryPool.newVector3f(minPos.x, maxPos.y, minPos.z), MemoryPool.newVector3f(minPos.x, minPos.y, maxPos.z), MemoryPool.newVector3f(maxPos.x, minPos.y, maxPos.z), MemoryPool.newVector3f(maxPos.x, maxPos.y, maxPos.z), MemoryPool.newVector3f(minPos.x, maxPos.y, maxPos.z)};
        for (int[] pair : edgeIndices = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            edges.add(new Vector3f[]{corners[pair[0]], corners[pair[1]]});
        }
        return edges;
    }

    public static List<Vector3f[]> getCubeFaces(Vector3f minPos, Vector3f maxPos) {
        int[][] faceIndices;
        ArrayList<Vector3f[]> faces = new ArrayList<Vector3f[]>();
        Vector3f[] corners = new Vector3f[]{new Vector3f(minPos.x, minPos.y, minPos.z), new Vector3f(maxPos.x, minPos.y, minPos.z), new Vector3f(maxPos.x, maxPos.y, minPos.z), new Vector3f(minPos.x, maxPos.y, minPos.z), new Vector3f(minPos.x, minPos.y, maxPos.z), new Vector3f(maxPos.x, minPos.y, maxPos.z), new Vector3f(maxPos.x, maxPos.y, maxPos.z), new Vector3f(minPos.x, maxPos.y, maxPos.z)};
        for (int[] pair : faceIndices = new int[][]{{3, 2, 1, 0}, {4, 5, 6, 7}, {4, 7, 3, 0}, {2, 6, 5, 1}, {7, 6, 2, 3}, {1, 5, 4, 0}}) {
            faces.add(new Vector3f[]{corners[pair[0]], corners[pair[1]], corners[pair[2]], corners[pair[3]]});
        }
        return faces;
    }

    static {
        earlyRenderCalls = new ArrayList();
        bloomfogPosColCalls = new ArrayList();
        renderCalls = new ArrayList();
        obstacleRenderCalls = new ArrayList();
        noteRenderCalls = new ArrayList();
        arrowRenderCalls = new ArrayList();
        laserRenderCalls = new ArrayList();
        laserPreRenderCalls = new ArrayList();
        lightRenderCalls = new ArrayList();
        arcRenderCalls = new ArrayList();
    }
}

