/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.block.entity;

import com.beatcraft.blocks.ModBlocks;
import com.beatcraft.blocks.ReflectiveMirrorStripBlock;
import com.beatcraft.blocks.entity.ReflectiveMirrorStripBlockEntity;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.effect.MirrorHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_827;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ReflectiveMirrorStripBlockEntityRenderer
implements class_827<ReflectiveMirrorStripBlockEntity> {
    private static final Vector3f[] localVertices = new Vector3f[]{new Vector3f(-0.375f, 0.375f, -0.5f), new Vector3f(-0.375f, 0.375f, 0.5f), new Vector3f(0.375f, 0.375f, 0.5f), new Vector3f(0.375f, 0.375f, -0.5f), new Vector3f(-0.375f, 0.5f, -0.5f), new Vector3f(-0.375f, 0.5f, 0.5f), new Vector3f(0.375f, 0.5f, 0.5f), new Vector3f(0.375f, 0.5f, -0.5f)};
    private static final int[][] faces = new int[][]{{1, 0, 3, 2}, {0, 1, 5, 4}, {2, 3, 7, 6}, {3, 0, 4, 7}, {1, 2, 6, 5}};
    private static final int[] topFace = new int[]{4, 5, 6, 7};

    private void drawQuad(int[] face, class_2338 pos, Vector3f cameraPos, boolean facingEast) {
        Vector3f center = pos.method_46558().method_46409();
        Quaternionf q = MemoryPool.newQuaternionf().rotationY(facingEast ? 1.5707964f : 0.0f);
        Vector3f f0 = MemoryPool.newVector3f(localVertices[face[0]]).rotate((Quaternionfc)q);
        Vector3f f1 = MemoryPool.newVector3f(localVertices[face[1]]).rotate((Quaternionfc)q);
        Vector3f f2 = MemoryPool.newVector3f(localVertices[face[2]]).rotate((Quaternionfc)q);
        Vector3f f3 = MemoryPool.newVector3f(localVertices[face[3]]).rotate((Quaternionfc)q);
        MemoryPool.release(q);
        Vector3f v0 = center.add((Vector3fc)f0, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v1 = center.add((Vector3fc)f1, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v2 = center.add((Vector3fc)f2, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v3 = center.add((Vector3fc)f3, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        MemoryPool.release(f0, f1, f2, f3);
        MirrorHandler.recordPlainCall((b, _c) -> this._drawQuad(v0, v1, v2, v3, (class_287)b));
    }

    private void _drawQuad(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, class_287 buffer) {
        buffer.method_60830(v0).method_39415(-16777216);
        buffer.method_60830(v1).method_39415(-16777216);
        buffer.method_60830(v2).method_39415(-16777216);
        buffer.method_60830(v3).method_39415(-16777216);
    }

    public void render(ReflectiveMirrorStripBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        class_2680 state = world.method_8320(entity.method_11016());
        if (!state.method_27852((class_2248)ModBlocks.REFLECTIVE_MIRROR_STRIP_BLOCK)) {
            return;
        }
        boolean facesEast = state.method_11654((class_2769)ReflectiveMirrorStripBlock.ROTATION) == class_2350.field_11034;
        for (int[] face : faces) {
            this.drawQuad(face, pos, cameraPos, facesEast);
        }
        if (pos.method_10264() == -1) {
            MirrorHandler.recordCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> this.drawMirror((class_287)b, (Vector3f)v, pos.method_46558().method_46409(), (Quaternionf)q, facesEast)));
        } else {
            this.drawQuad(topFace, pos, cameraPos, facesEast);
        }
    }

    public boolean isInRenderDistance(ReflectiveMirrorStripBlockEntity blockEntity, class_243 pos) {
        return true;
    }

    private void drawMirror(class_287 buffer, Vector3f cameraPos, Vector3f center, Quaternionf invCameraRotation, boolean facingEast) {
        Quaternionf q = MemoryPool.newQuaternionf().rotationY(facingEast ? 1.5707964f : 0.0f);
        Vector3f f0 = MemoryPool.newVector3f(localVertices[topFace[0]]).rotate((Quaternionfc)q);
        Vector3f f1 = MemoryPool.newVector3f(localVertices[topFace[1]]).rotate((Quaternionfc)q);
        Vector3f f2 = MemoryPool.newVector3f(localVertices[topFace[2]]).rotate((Quaternionfc)q);
        Vector3f f3 = MemoryPool.newVector3f(localVertices[topFace[3]]).rotate((Quaternionfc)q);
        MemoryPool.release(q);
        Vector3f v0 = center.add((Vector3fc)f0, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v1 = center.add((Vector3fc)f1, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v2 = center.add((Vector3fc)f2, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        Vector3f v3 = center.add((Vector3fc)f3, MemoryPool.newVector3f()).sub((Vector3fc)cameraPos);
        buffer.method_60830(v0).method_39415(-16777216);
        buffer.method_60830(v1).method_39415(-16777216);
        buffer.method_60830(v2).method_39415(-16777216);
        buffer.method_60830(v3).method_39415(-16777216);
    }
}

