/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.effect;

import com.beatcraft.logic.Hitbox;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ObstacleGlowRenderer {
    public static class_5944 distortionShader;
    public static class_5944 blitShader;
    public static class_6367 framebuffer;

    public static void init() {
        try {
            distortionShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "col_distortion", class_290.field_1575);
            blitShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "blit_screen", class_290.field_1585);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void grabScreen() {
        class_276 scene = class_310.method_1551().method_1522();
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.method_1230(true);
        framebuffer.method_1235(true);
        BeatCraftRenderer.bloomfog.overrideBuffer = true;
        BeatCraftRenderer.bloomfog.overrideFramebuffer = framebuffer;
        distortionShader.method_34583("DiffuseSampler", (Object)scene.method_30277());
        RenderSystem.setShaderTexture((int)0, (int)scene.method_30277());
        RenderSystem.setShader(() -> blitShader);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912(-1.0f, -1.0f, 0.0f).method_22913(0.0f, 0.0f);
        buffer.method_22912(-1.0f, 1.0f, 0.0f).method_22913(0.0f, 1.0f);
        buffer.method_22912(1.0f, 1.0f, 0.0f).method_22913(1.0f, 1.0f);
        buffer.method_22912(1.0f, -1.0f, 0.0f).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        framebuffer.method_1240();
        BeatCraftRenderer.bloomfog.overrideBuffer = false;
        BeatCraftRenderer.bloomfog.overrideFramebuffer = null;
        class_310.method_1551().method_1522().method_1235(true);
    }

    private static Vector3f[] buildEdge(Vector3f pos1, Vector3f pos2, Vector3f cameraPos) {
        Vector3f lineNormal = MemoryPool.newVector3f(pos1).sub((Vector3fc)pos2).normalize();
        Vector3f p1normal = MemoryPool.newVector3f(pos1).sub((Vector3fc)cameraPos).normalize();
        Vector3f p2normal = MemoryPool.newVector3f(pos2).sub((Vector3fc)cameraPos).normalize();
        Vector3f p1offset = MemoryPool.newVector3f(lineNormal).cross((Vector3fc)p1normal).normalize().mul(0.05f);
        Vector3f p2offset = lineNormal.cross((Vector3fc)p2normal).normalize().mul(0.05f);
        Vector3f[] out = new Vector3f[]{MemoryPool.newVector3f(pos1).add((Vector3fc)p1offset), MemoryPool.newVector3f(pos1).sub((Vector3fc)p1offset), MemoryPool.newVector3f(pos2).sub((Vector3fc)p2offset), MemoryPool.newVector3f(pos2).add((Vector3fc)p2offset)};
        MemoryPool.release(p1normal, p2normal, p1offset, p2offset);
        return out;
    }

    public static void render(Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        if (distortionShader == null) {
            ObstacleGlowRenderer.init();
        }
        BeatCraftRenderer.recordLaserRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(buffer, camera) -> ObstacleGlowRenderer._render(position, orientation, bounds, color, buffer, camera, false)));
        Vector3f p = MemoryPool.newVector3f(position);
        Quaternionf o = MemoryPool.newQuaternionf(orientation);
        BeatCraftRenderer.recordLaserPreRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(buffer, camera) -> ObstacleGlowRenderer._render(p, o, bounds, color, buffer, camera, false)));
    }

    public static void renderMirrored(Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        Vector3f flippedPos = position.mul(1.0f, -1.0f, 1.0f);
        Quaternionf flippedOrientation = MemoryPool.newQuaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        MemoryPool.release(orientation);
        MirrorHandler.recordMirrorLaserRenderCall((buffer, camera) -> ObstacleGlowRenderer._render(flippedPos, flippedOrientation, bounds, color, buffer, camera, true));
    }

    public static void _render(Vector3f position, Quaternionf orientation, Hitbox bounds, int color, class_287 buffer, Vector3f cameraPos, boolean mirrored) {
        List<Vector3f[]> edges = BeatCraftRenderer.getCubeEdges(bounds.min, bounds.max);
        Vector3f e0 = MemoryPool.newVector3f();
        Vector3f e1 = MemoryPool.newVector3f();
        for (Vector3f[] edge : edges) {
            e0.set((Vector3fc)edge[0]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            e1.set((Vector3fc)edge[1]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            Vector3f[] mesh = ObstacleGlowRenderer.buildEdge(e0, e1, cameraPos);
            int fadeColor = 0xFFFFFF & color | 0x1000000;
            buffer.method_22912(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(mesh[3].x - cameraPos.x, mesh[3].y - cameraPos.y, mesh[3].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(mesh[0].x - cameraPos.x, mesh[0].y - cameraPos.y, mesh[0].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(mesh[2].x - cameraPos.x, mesh[2].y - cameraPos.y, mesh[2].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(mesh[1].x - cameraPos.x, mesh[1].y - cameraPos.y, mesh[1].z - cameraPos.z).method_39415(fadeColor);
            MemoryPool.release(mesh);
        }
        MemoryPool.release(e0, e1);
        MemoryPool.release(position);
    }

    static {
        framebuffer = new class_6367(1920, 1080, true, true);
    }
}

