/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.effect;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.data.ControllerProfile;
import com.beatcraft.data.components.ModComponents;
import com.beatcraft.data.types.Stash;
import com.beatcraft.items.ModItems;
import com.beatcraft.items.data.ItemStackWithSaberTrailStash;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.beatcraft.networking.c2s.BeatSyncC2SPayload;
import com.beatcraft.networking.c2s.SaberSyncC2SPayload;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.replay.PlayFrame;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_8251;
import net.minecraft.class_8710;
import net.minecraft.class_9801;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;

@Environment(value=EnvType.CLIENT)
public class SaberRenderer {
    public static final HashMap<UUID, PlayFrame> otherPlayerSabers = new HashMap();
    private static final ArrayList<Function<class_287, Void>> render_calls = new ArrayList();

    private static void renderOtherPlayerSabers() {
        otherPlayerSabers.forEach((uuid, playFrame) -> {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            class_1657 player = world.method_18470(uuid);
            if (player == null) {
                return;
            }
            boolean tracked = GameLogicHandler.isTracking(uuid);
            class_1799 stack = player.method_6047();
            class_1799 stack2 = player.method_6079();
            if (player.method_6068() == class_1306.field_6182) {
                class_1799 s3 = stack;
                stack = stack2;
                stack2 = s3;
            }
            if (stack.method_31574((class_1792)ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack, playFrame.rightSaberPosition(), playFrame.rightSaberRotation());
                if (tracked) {
                    GameLogicHandler.updateRightSaber(playFrame.rightSaberPosition(), playFrame.rightSaberRotation());
                }
            }
            if (stack2.method_31574((class_1792)ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack2, playFrame.leftSaberPosition(), playFrame.leftSaberRotation());
                if (tracked) {
                    GameLogicHandler.updateLeftSaber(playFrame.leftSaberPosition(), playFrame.leftSaberRotation());
                }
            }
        });
    }

    public static void renderReplaySaber(class_1799 item, Vector3f position, Quaternionf orientation) {
        SaberRenderer.renderReplayTrail(item, position, orientation);
        class_4587 matrices = new class_4587();
        Vector3f cam = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        matrices.method_46416(-cam.x, -cam.y, -cam.z);
        matrices.method_46416(position.x, position.y, position.z);
        matrices.method_22907(orientation);
        matrices.method_22905(0.3333f, 0.3333f, 0.3333f);
        BeatCraftRenderer.recordRenderCall(() -> class_310.method_1551().method_1480().method_23178(item, class_811.field_4322, 255, 0, matrices, HUDRenderer.vertexConsumerProvider, (class_1937)class_310.method_1551().field_1687, 0));
    }

    public static void renderSaber(class_1799 item, class_4587 matrices, class_4597.class_4598 vertexConsumerProvider, class_1268 hand, class_742 player, float tickDelta) {
        matrices.method_22903();
        SaberRenderer.renderTrail(true, matrices, hand == class_1268.field_5808, player, tickDelta, item);
        Vector3f worldPos = matrices.method_23760().method_23761().getTranslation(new Vector3f()).add((Vector3fc)BeatCraftClient.playerGlobalPosition.method_46409()).add((Vector3fc)BeatCraftClient.playerSaberPosition.method_46409()).sub((Vector3fc)BeatCraftClient.playerCameraPosition.method_46409());
        Quaternionf worldRotation = hand == class_1268.field_5808 ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_4587 matrixStack = new class_4587();
        matrixStack.method_46416(worldPos.x, worldPos.y, worldPos.z);
        matrixStack.method_22907(worldRotation);
        matrixStack.method_22905(0.3333f, 0.3333f, 0.3333f);
        class_310.method_1551().method_1480().method_23178(item, class_811.field_4322, 255, 0, matrixStack, (class_4597)vertexConsumerProvider, null, 0);
        matrices.method_22909();
        ClientPlayNetworking.send((class_8710)new SaberSyncC2SPayload(GameLogicHandler.leftSaberPos, GameLogicHandler.leftSaberRotation, GameLogicHandler.rightSaberPos, GameLogicHandler.rightSaberRotation, GameLogicHandler.headPos, GameLogicHandler.headRot));
        if (GameLogicHandler.isTrackingClient() && BeatmapPlayer.isPlaying()) {
            ClientPlayNetworking.send((class_8710)new BeatSyncC2SPayload(BeatmapPlayer.getCurrentBeat()));
        }
    }

    public static void renderReplayTrail(class_1799 stack, Vector3f basePos, Quaternionf rotation) {
        Vector3f hiltPos = new Vector3f(0.0f, 0.175f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        Vector3f tipPos = new Vector3f(0.0f, 1.025f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        Stash<class_3545<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStash)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
        int sync = (Integer)stack.method_57825(ModComponents.AUTO_SYNC_COLOR, (Object)-1);
        int color = sync == -1 || BeatmapPlayer.currentBeatmap == null ? (Integer)stack.method_57825(ModComponents.SABER_COLOR_COMPONENT, (Object)0) + -16777216 : (sync == 0 ? BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
        SaberRenderer.queueRender(hiltPos, tipPos, stash, color);
    }

    public static void renderTrail(boolean doCollisionCheck, class_4587 matrix, boolean mainHand, class_742 player, float tickDelta, class_1799 stack) {
        if (stack.method_31574((class_1792)ModItems.SABER_ITEM)) {
            boolean rightHand;
            Quaternionf rotation;
            Vector3f translation;
            matrix.method_22905(0.3333f, 0.3333f, 0.3333f);
            matrix.method_22904(0.0, -0.25, 0.35);
            matrix.method_22907(new Quaternionf().rotationXYZ(-0.7853982f, 0.0f, 0.0f));
            ControllerProfile profile = BeatCraftClient.playerConfig.getActiveControllerProfile();
            if (player.method_6068() == class_1306.field_6183 && mainHand || player.method_6068() == class_1306.field_6182 && !mainHand) {
                translation = profile.getRightTranslation();
                rotation = profile.getRightRotation();
                rightHand = true;
            } else {
                translation = profile.getLeftTranslation();
                rotation = profile.getLeftRotation();
                rightHand = false;
            }
            matrix.method_46416(translation.x, translation.y, translation.z);
            matrix.method_22907(rotation);
            if (doCollisionCheck) {
                matrix.method_22903();
                matrix.method_22904(0.0, 0.525, 0.0);
                Vector3f blade_base = matrix.method_23760().method_23761().getTranslation(new Vector3f());
                matrix.method_22909();
                matrix.method_22903();
                matrix.method_22904(0.0, 3.0749999999999997, 0.0);
                Vector3f blade_tip = matrix.method_23760().method_23761().getTranslation(new Vector3f());
                matrix.method_22909();
                matrix.method_22903();
                matrix.method_22904(0.0, 0.15, 0.0);
                class_4587.class_4665 entry = matrix.method_23760();
                matrix.method_22909();
                class_243 playerPos = player.method_30950(tickDelta);
                Vector3f saberPos = entry.method_23761().getTranslation(new Vector3f());
                saberPos.add((float)playerPos.field_1352, (float)playerPos.field_1351, (float)playerPos.field_1350);
                Quaternionf saberRot = entry.method_23761().getUnnormalizedRotation(new Quaternionf());
                if (GameLogicHandler.isTrackingClient()) {
                    if (rightHand) {
                        GameLogicHandler.updateRightSaber(saberPos, saberRot);
                    } else {
                        GameLogicHandler.updateLeftSaber(saberPos, saberRot);
                    }
                }
                blade_tip = blade_tip.add((float)playerPos.field_1352, (float)playerPos.field_1351, (float)playerPos.field_1350);
                blade_base = blade_base.add((float)playerPos.field_1352, (float)playerPos.field_1351, (float)playerPos.field_1350);
                Stash<class_3545<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStash)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
                int sync = (Integer)stack.method_57825(ModComponents.AUTO_SYNC_COLOR, (Object)-1);
                int color = sync == -1 || BeatmapPlayer.currentBeatmap == null ? (Integer)stack.method_57825(ModComponents.SABER_COLOR_COMPONENT, (Object)0) + -16777216 : (sync == 0 ? BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
                if (stash != null) {
                    SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
                }
            }
        }
    }

    public static void renderItemEntityTrail(class_1542 entity, float tickDelta, class_1087 bakedModel) {
        class_1799 stack = entity.method_6983();
        if (stack.method_31574((class_1792)ModItems.SABER_ITEM)) {
            class_4587 matrix = new class_4587();
            float j = class_3532.method_15374((float)(((float)entity.method_6985() + tickDelta) / 10.0f + entity.field_7203)) * 0.1f + 0.1f;
            float k = bakedModel.method_4709().method_3503((class_811)class_811.field_4318).field_4285.y();
            matrix.method_46416(0.0f, j + 0.25f * k, 0.0f);
            float l = entity.method_27314(tickDelta);
            matrix.method_22907(class_7833.field_40716.rotation(l));
            matrix.method_22903();
            bakedModel.method_4709().method_3503(class_811.field_4318).method_23075(false, matrix);
            matrix.method_22903();
            matrix.method_22904(0.0, 0.525, 0.0);
            Vector3f blade_base = matrix.method_23760().method_23761().getTranslation(new Vector3f());
            matrix.method_22909();
            matrix.method_22903();
            matrix.method_22904(0.0, 3.0749999999999997, 0.0);
            Vector3f blade_tip = matrix.method_23760().method_23761().getTranslation(new Vector3f());
            matrix.method_22909();
            class_243 pos = entity.method_30950(tickDelta);
            blade_base = blade_base.add((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
            blade_tip = blade_tip.add((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
            Stash<class_3545<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStash)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
            int sync = (Integer)stack.method_57825(ModComponents.AUTO_SYNC_COLOR, (Object)-1);
            int color = sync == -1 || BeatmapPlayer.currentBeatmap == null ? (Integer)stack.method_57825(ModComponents.SABER_COLOR_COMPONENT, (Object)0) + -16777216 : (sync == 0 ? BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
            if (stash != null) {
                SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
            }
        }
    }

    public static void queueRender(Vector3f blade_base, Vector3f blade_tip, Stash<class_3545<Vector3f, Vector3f>> stash, int col) {
        Function<class_287, Void> callable = trail_buffer -> {
            SaberRenderer.render(blade_base, blade_tip, stash, col, trail_buffer);
            return null;
        };
        render_calls.add(callable);
    }

    public static void renderAll() {
        SaberRenderer.renderOtherPlayerSabers();
        if (render_calls.isEmpty()) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 trail_buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (Function<class_287, Void> runnable : render_calls) {
            runnable.apply(trail_buffer);
        }
        class_9801 buffer = trail_buffer.method_60794();
        render_calls.clear();
        if (buffer != null) {
            buffer.method_60819(((BufferBuilderAccessor)trail_buffer).beatcraft$getAllocator(), class_8251.field_43361);
            class_286.method_43433((class_9801)buffer);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public static void render(Vector3f blade_base, Vector3f blade_tip, Stash<class_3545<Vector3f, Vector3f>> stash, int col, class_287 trail_buffer) {
        Vector3f current_base = blade_base;
        Vector3f current_tip = blade_tip;
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        if (!stash.isEmpty()) {
            int opacity = 0;
            float step = 127.0f / (float)stash.getSize();
            for (class_3545<Vector3f, Vector3f> ab : stash) {
                Vector3f a = (Vector3f)ab.method_15442();
                Vector3f b = (Vector3f)ab.method_15441();
                int op = 127 - (int)(step * (float)opacity) << 24;
                int op2 = 127 - (int)(step * (float)(opacity + 1)) << 24;
                ++opacity;
                if (op == 0 || op2 == 0) continue;
                trail_buffer.method_22912((float)((double)current_base.x - cam.field_1352), (float)((double)current_base.y - cam.field_1351), (float)((double)current_base.z - cam.field_1350)).method_39415(col + op);
                trail_buffer.method_22912((float)((double)a.x - cam.field_1352), (float)((double)a.y - cam.field_1351), (float)((double)a.z - cam.field_1350)).method_39415(col + op2);
                trail_buffer.method_22912((float)((double)b.x - cam.field_1352), (float)((double)b.y - cam.field_1351), (float)((double)b.z - cam.field_1350)).method_39415(col + op2);
                trail_buffer.method_22912((float)((double)current_tip.x - cam.field_1352), (float)((double)current_tip.y - cam.field_1351), (float)((double)current_tip.z - cam.field_1350)).method_39415(col + op);
                current_base = a;
                current_tip = b;
            }
        }
        stash.push((class_3545<Vector3f, Vector3f>)new class_3545((Object)blade_base, (Object)blade_tip));
    }
}

